/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.jpa.conf;

import java.lang.reflect.AnnotatedElement;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.apache.cayenne.jpa.conf.AnnotationProcessor;
import org.apache.cayenne.jpa.conf.AnnotationProcessorFactory;
import org.apache.cayenne.jpa.conf.AnnotationProcessorStack;
import org.apache.cayenne.jpa.conf.EntityListenerAnnotationLoader;
import org.apache.cayenne.jpa.map.JpaAttributeOverride;
import org.apache.cayenne.jpa.map.JpaAttributes;
import org.apache.cayenne.jpa.map.JpaDiscriminatorColumn;
import org.apache.cayenne.jpa.map.JpaEmbeddable;
import org.apache.cayenne.jpa.map.JpaEntity;
import org.apache.cayenne.jpa.map.JpaEntityListener;
import org.apache.cayenne.jpa.map.JpaEntityListeners;
import org.apache.cayenne.jpa.map.JpaEntityMap;
import org.apache.cayenne.jpa.map.JpaIdClass;
import org.apache.cayenne.jpa.map.JpaInheritance;
import org.apache.cayenne.jpa.map.JpaMappedSuperclass;
import org.apache.cayenne.jpa.map.JpaNamedNativeQuery;
import org.apache.cayenne.jpa.map.JpaNamedQuery;
import org.apache.cayenne.jpa.map.JpaPrimaryKeyJoinColumn;
import org.apache.cayenne.jpa.map.JpaSecondaryTable;
import org.apache.cayenne.jpa.map.JpaSequenceGenerator;
import org.apache.cayenne.jpa.map.JpaSqlResultSetMapping;
import org.apache.cayenne.jpa.map.JpaTable;
import org.apache.cayenne.jpa.map.JpaTableGenerator;
import org.apache.cayenne.util.Util;

class ClassAnnotationProcessorFactory
extends AnnotationProcessorFactory {
    ClassAnnotationProcessorFactory() {
    }

    static final class TableProcessor
    extends AbstractChildProcessor {
        TableProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            Table annotation = element.getAnnotation(Table.class);
            entity.setTable(new JpaTable(annotation));
        }
    }

    static final class TableGeneratorProcessor
    extends AbstractChildProcessor {
        TableGeneratorProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            TableGenerator annotation = element.getAnnotation(TableGenerator.class);
            entity.setTableGenerator(new JpaTableGenerator(annotation));
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            TableGenerator annotation = element.getAnnotation(TableGenerator.class);
            entityMap.getTableGenerators().add(new JpaTableGenerator(annotation));
        }
    }

    static final class SqlResultSetMappingProcessor
    extends AbstractChildProcessor {
        SqlResultSetMappingProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            SqlResultSetMapping annotation = element.getAnnotation(SqlResultSetMapping.class);
            entity.getSqlResultSetMappings().add(new JpaSqlResultSetMapping(annotation));
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            SqlResultSetMapping annotation = element.getAnnotation(SqlResultSetMapping.class);
            entityMap.getSqlResultSetMappings().add(new JpaSqlResultSetMapping(annotation));
        }
    }

    static final class SequenceGeneratorProcessor
    extends AbstractChildProcessor {
        SequenceGeneratorProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            SequenceGenerator annotation = element.getAnnotation(SequenceGenerator.class);
            entity.setSequenceGenerator(new JpaSequenceGenerator(annotation));
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            SequenceGenerator annotation = element.getAnnotation(SequenceGenerator.class);
            entityMap.getSequenceGenerators().add(new JpaSequenceGenerator(annotation));
        }
    }

    static final class SecondaryTablesProcessor
    extends AbstractChildProcessor {
        SecondaryTablesProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            SecondaryTables annotation = element.getAnnotation(SecondaryTables.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entity.getSecondaryTables().add(new JpaSecondaryTable(annotation.value()[i]));
            }
        }
    }

    static final class SecondaryTableProcessor
    extends AbstractChildProcessor {
        SecondaryTableProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            SecondaryTable annotation = element.getAnnotation(SecondaryTable.class);
            entity.getSecondaryTables().add(new JpaSecondaryTable(annotation));
        }
    }

    static final class PrimaryKeyJoinColumnsProcessor
    extends AbstractChildProcessor {
        PrimaryKeyJoinColumnsProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            PrimaryKeyJoinColumns annotation = element.getAnnotation(PrimaryKeyJoinColumns.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entity.getPrimaryKeyJoinColumns().add(new JpaPrimaryKeyJoinColumn(annotation.value()[i]));
            }
        }
    }

    static final class PrimaryKeyJoinColumnProcessor
    extends AbstractChildProcessor {
        PrimaryKeyJoinColumnProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            PrimaryKeyJoinColumn annotation = element.getAnnotation(PrimaryKeyJoinColumn.class);
            entity.getPrimaryKeyJoinColumns().add(new JpaPrimaryKeyJoinColumn(annotation));
        }
    }

    static final class NamedQueryProcessor
    extends AbstractChildProcessor {
        NamedQueryProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedQuery annotation = element.getAnnotation(NamedQuery.class);
            entity.getNamedQueries().add(new JpaNamedQuery(annotation));
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedQuery annotation = element.getAnnotation(NamedQuery.class);
            entityMap.getNamedQueries().add(new JpaNamedQuery(annotation));
        }
    }

    static final class NamedQueriesProcessor
    extends AbstractChildProcessor {
        NamedQueriesProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedQueries annotation = element.getAnnotation(NamedQueries.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entity.getNamedQueries().add(new JpaNamedQuery(annotation.value()[i]));
            }
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedQueries annotation = element.getAnnotation(NamedQueries.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entityMap.getNamedQueries().add(new JpaNamedQuery(annotation.value()[i]));
            }
        }
    }

    static final class NamedNativeQueryProcessor
    extends AbstractChildProcessor {
        NamedNativeQueryProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedNativeQuery annotation = element.getAnnotation(NamedNativeQuery.class);
            entity.getNamedNativeQueries().add(new JpaNamedNativeQuery(annotation));
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedNativeQuery annotation = element.getAnnotation(NamedNativeQuery.class);
            entityMap.getNamedNativeQueries().add(new JpaNamedNativeQuery(annotation));
        }
    }

    static final class NamedNativeQueriesProcessor
    extends AbstractChildProcessor {
        NamedNativeQueriesProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedNativeQueries annotation = element.getAnnotation(NamedNativeQueries.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entity.getNamedNativeQueries().add(new JpaNamedNativeQuery(annotation.value()[i]));
            }
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            NamedNativeQueries annotation = element.getAnnotation(NamedNativeQueries.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entityMap.getNamedNativeQueries().add(new JpaNamedNativeQuery(annotation.value()[i]));
            }
        }
    }

    static final class InheritanceProcessor
    extends AbstractChildProcessor {
        InheritanceProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            Inheritance annotation = element.getAnnotation(Inheritance.class);
            entity.setInheritance(new JpaInheritance(annotation));
        }
    }

    static final class IdClassProcessor
    extends AbstractChildProcessor {
        IdClassProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            IdClass annotation = element.getAnnotation(IdClass.class);
            JpaIdClass idClass = new JpaIdClass();
            idClass.setClassName(annotation.value().getName());
            entity.setIdClass(idClass);
        }

        void onMappedSuperclass(JpaMappedSuperclass superclass, AnnotatedElement element, AnnotationProcessorStack context) {
            IdClass annotation = element.getAnnotation(IdClass.class);
            JpaIdClass idClass = new JpaIdClass();
            idClass.setClassName(annotation.value().getName());
            superclass.setIdClass(idClass);
        }
    }

    static final class ExcludeSuperclassListenersProcessor
    extends AbstractChildProcessor {
        ExcludeSuperclassListenersProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            entity.setExcludeSuperclassListeners(true);
        }

        void onMappedSuperclass(JpaMappedSuperclass superclass, AnnotatedElement element, AnnotationProcessorStack context) {
            superclass.setExcludeSuperclassListeners(true);
        }
    }

    static final class ExcludeDefaultListenersProcessor
    extends AbstractChildProcessor {
        ExcludeDefaultListenersProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            entity.setExcludeDefaultListeners(true);
        }

        void onMappedSuperclass(JpaMappedSuperclass superclass, AnnotatedElement element, AnnotationProcessorStack context) {
            superclass.setExcludeDefaultListeners(true);
        }
    }

    static final class EntityListenersProcessor
    extends AbstractChildProcessor {
        private EntityListenerAnnotationLoader listenerLoader;

        EntityListenersProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            EntityListeners annotation = element.getAnnotation(EntityListeners.class);
            if (annotation.value().length > 0) {
                JpaEntityListeners listenerHolder;
                if (this.listenerLoader == null) {
                    this.listenerLoader = new EntityListenerAnnotationLoader();
                }
                if ((listenerHolder = entity.getEntityListeners()) == null) {
                    listenerHolder = new JpaEntityListeners();
                    entity.setEntityListeners(listenerHolder);
                }
                for (int i = 0; i < annotation.value().length; ++i) {
                    JpaEntityListener listener = this.listenerLoader.getEntityListener(annotation.value()[i]);
                    if (listener == null) continue;
                    listenerHolder.getEntityListeners().add(listener);
                }
            }
        }

        void onMappedSuperclass(JpaMappedSuperclass superclass, AnnotatedElement element, AnnotationProcessorStack context) {
            EntityListeners annotation = element.getAnnotation(EntityListeners.class);
            if (annotation.value().length > 0) {
                JpaEntityListeners listenerHolder;
                if (this.listenerLoader == null) {
                    this.listenerLoader = new EntityListenerAnnotationLoader();
                }
                if ((listenerHolder = superclass.getEntityListeners()) == null) {
                    listenerHolder = new JpaEntityListeners();
                    superclass.setEntityListeners(listenerHolder);
                }
                for (int i = 0; i < annotation.value().length; ++i) {
                    JpaEntityListener listener = this.listenerLoader.getEntityListener(annotation.value()[i]);
                    if (listener == null) continue;
                    listenerHolder.getEntityListeners().add(listener);
                }
            }
        }
    }

    static final class DiscriminatorValueProcessor
    extends AbstractChildProcessor {
        DiscriminatorValueProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            DiscriminatorValue annotation = element.getAnnotation(DiscriminatorValue.class);
            entity.setDiscriminatorValue(annotation.value());
        }
    }

    static final class DiscriminatorColumnProcessor
    extends AbstractChildProcessor {
        DiscriminatorColumnProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            DiscriminatorColumn annotation = element.getAnnotation(DiscriminatorColumn.class);
            entity.setDiscriminatorColumn(new JpaDiscriminatorColumn(annotation));
        }
    }

    static final class AttributeOverridesProcessor
    extends AbstractChildProcessor {
        AttributeOverridesProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            AttributeOverrides annotation = element.getAnnotation(AttributeOverrides.class);
            for (int i = 0; i < annotation.value().length; ++i) {
                entity.getAttributeOverrides().add(new JpaAttributeOverride(annotation.value()[i]));
            }
        }
    }

    static final class AttributeOverrideProcessor
    extends AbstractChildProcessor {
        AttributeOverrideProcessor() {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            AttributeOverride annotation = element.getAnnotation(AttributeOverride.class);
            entity.getAttributeOverrides().add(new JpaAttributeOverride(annotation));
        }
    }

    static abstract class AbstractChildProcessor
    implements AnnotationProcessor {
        AbstractChildProcessor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Object parent = context.peek();
            if (parent instanceof JpaEntity) {
                this.onEntity((JpaEntity)parent, element, context);
            } else if (parent instanceof JpaMappedSuperclass) {
                this.onMappedSuperclass((JpaMappedSuperclass)parent, element, context);
            } else if (parent instanceof JpaEntityMap) {
                this.onEntityMap((JpaEntityMap)parent, element, context);
            } else if (parent instanceof JpaEmbeddable) {
                this.onEmbeddable((JpaEmbeddable)parent, element, context);
            } else {
                this.recordUnsupportedAnnotation(element, context);
            }
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
        }

        void onEntity(JpaEntity entity, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void onMappedSuperclass(JpaMappedSuperclass superclass, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void onEmbeddable(JpaEmbeddable embeddable, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void onEntityMap(JpaEntityMap entityMap, AnnotatedElement element, AnnotationProcessorStack context) {
            this.recordUnsupportedAnnotation(element, context);
        }

        void recordUnsupportedAnnotation(AnnotatedElement element, AnnotationProcessorStack context) {
            context.recordConflict(element, AnnotationProcessorFactory.annotationClass(this.getClass()), "Unsupported in this place");
        }
    }

    static final class MappedSuperclassProcessor
    implements AnnotationProcessor {
        MappedSuperclassProcessor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaMappedSuperclass superclass = new JpaMappedSuperclass();
            superclass.setClassName(((Class)element).getName());
            superclass.setAttributes(new JpaAttributes());
            context.push(superclass);
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaMappedSuperclass superclass = (JpaMappedSuperclass)context.pop();
            JpaEntityMap entityMap = (JpaEntityMap)context.peek();
            entityMap.getMappedSuperclasses().add(superclass);
        }
    }

    static final class EmbeddableProcessor
    implements AnnotationProcessor {
        EmbeddableProcessor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaEmbeddable embeddable = new JpaEmbeddable();
            embeddable.setClassName(((Class)element).getName());
            embeddable.setAttributes(new JpaAttributes());
            context.push(embeddable);
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaEmbeddable embeddable = (JpaEmbeddable)context.pop();
            JpaEntityMap entityMap = (JpaEntityMap)context.peek();
            entityMap.getEmbeddables().add(embeddable);
        }
    }

    static final class EntityProcessor
    implements AnnotationProcessor {
        EntityProcessor() {
        }

        public void onStartElement(AnnotatedElement element, AnnotationProcessorStack context) {
            Entity entityAnnotation = element.getAnnotation(Entity.class);
            JpaEntity entity = new JpaEntity();
            entity.setClassName(((Class)element).getName());
            entity.setAttributes(new JpaAttributes());
            if (!Util.isEmptyString(entityAnnotation.name())) {
                entity.setName(entityAnnotation.name());
            }
            context.push(entity);
        }

        public void onFinishElement(AnnotatedElement element, AnnotationProcessorStack context) {
            JpaEntity entity = (JpaEntity)context.pop();
            JpaEntityMap entityMap = (JpaEntityMap)context.peek();
            entityMap.getEntities().add(entity);
        }
    }
}

