/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnToDb
extends AbstractToDbToken.EntityAndColumn {
    public AddColumnToDb(DbEntity entity, DbAttribute column) {
        super(entity, column);
    }

    protected void appendPrefix(StringBuffer sqlBuffer) {
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(this.getEntity().getFullyQualifiedName());
        sqlBuffer.append(" ADD COLUMN ");
        sqlBuffer.append(this.getColumn().getName());
        sqlBuffer.append(" ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        this.appendPrefix(sqlBuffer);
        String[] types = adapter.externalTypesForJdbcType(this.getColumn().getType());
        if (types == null || types.length == 0) {
            String entityName = this.getColumn().getEntity() != null ? ((DbEntity)this.getColumn().getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + this.getColumn().getName() + "': " + this.getColumn().getType());
        }
        String type = types[0];
        sqlBuffer.append(type);
        if (TypesMapping.supportsLength(this.getColumn().getType())) {
            int scale;
            int len = this.getColumn().getMaxLength();
            int n = scale = TypesMapping.isDecimal(this.getColumn().getType()) ? this.getColumn().getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenName() {
        return "Add Column";
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropColumnToModel(this.getEntity(), this.getColumn());
    }
}

