/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship rel;

    public AddRelationshipToDb(DbEntity entity, DbRelationship rel) {
        super(entity);
        this.rel = rel;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        String fksql;
        if (!this.rel.isToMany() && this.rel.isToPK() && !this.rel.isToDependentPK() && (fksql = adapter.createFkConstraint(this.rel)) != null) {
            return Collections.singletonList(fksql);
        }
        return Collections.emptyList();
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropRelationshipToModel(this.getEntity(), this.rel);
    }

    @Override
    public String getTokenName() {
        return "Add Relationship";
    }

    @Override
    public String getTokenValue() {
        StringBuilder s = new StringBuilder();
        s.append(this.rel.getSourceEntity().getName());
        s.append("->");
        s.append(this.rel.getTargetEntityName());
        return s.toString();
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }
}

