/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.Collection;
import org.apache.cayenne.LifecycleListener;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleCallbackRegistry {
    private LifecycleCallbackEventHandler[] eventCallbacks = new LifecycleCallbackEventHandler[LifecycleEvent.values().length];

    public LifecycleCallbackRegistry(EntityResolver resolver) {
        for (int i = 0; i < this.eventCallbacks.length; ++i) {
            this.eventCallbacks[i] = new LifecycleCallbackEventHandler(resolver);
        }
    }

    public void clear() {
        for (LifecycleCallbackEventHandler eventCallback : this.eventCallbacks) {
            eventCallback.clear();
        }
    }

    public void clear(int type) {
        this.eventCallbacks[type].clear();
    }

    public boolean isEmpty(LifecycleEvent type) {
        return this.eventCallbacks[type.ordinal()].isEmpty();
    }

    public void addDefaultListener(LifecycleListener listener) {
        this.addDefaultListener(LifecycleEvent.PRE_PERSIST, listener, "prePersist");
        this.addDefaultListener(LifecycleEvent.POST_PERSIST, listener, "postPersist");
        this.addDefaultListener(LifecycleEvent.PRE_REMOVE, listener, "preRemove");
        this.addDefaultListener(LifecycleEvent.POST_REMOVE, listener, "postRemove");
        this.addDefaultListener(LifecycleEvent.PRE_UPDATE, listener, "preUpdate");
        this.addDefaultListener(LifecycleEvent.POST_UPDATE, listener, "postUpdate");
        this.addDefaultListener(LifecycleEvent.POST_LOAD, listener, "postLoad");
    }

    public void addDefaultListener(LifecycleEvent type, Object listener, String methodName) {
        this.eventCallbacks[type.ordinal()].addDefaultListener(listener, methodName);
    }

    public void addListener(Class<?> entityClass, LifecycleListener listener) {
        this.addListener(LifecycleEvent.PRE_PERSIST, entityClass, listener, "prePersist");
        this.addListener(LifecycleEvent.POST_PERSIST, entityClass, listener, "postPersist");
        this.addListener(LifecycleEvent.PRE_REMOVE, entityClass, listener, "preRemove");
        this.addListener(LifecycleEvent.POST_REMOVE, entityClass, listener, "postRemove");
        this.addListener(LifecycleEvent.PRE_UPDATE, entityClass, listener, "preUpdate");
        this.addListener(LifecycleEvent.POST_UPDATE, entityClass, listener, "postUpdate");
        this.addListener(LifecycleEvent.POST_LOAD, entityClass, listener, "postLoad");
    }

    public void addListener(LifecycleEvent type, Class<?> entityClass, Object listener, String methodName) {
        this.eventCallbacks[type.ordinal()].addListener(entityClass, listener, methodName);
    }

    public void addListener(LifecycleEvent type, Class<?> entityClass, String methodName) {
        this.eventCallbacks[type.ordinal()].addListener(entityClass, methodName);
    }

    public void performCallbacks(LifecycleEvent type, Persistent object) {
        this.eventCallbacks[type.ordinal()].performCallbacks(object);
    }

    public void performCallbacks(LifecycleEvent type, Collection<?> objects) {
        this.eventCallbacks[type.ordinal()].performCallbacks(objects);
    }
}

