/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.pojo;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.enhancer.EnhancementHelper;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.FaultFactory;
import org.apache.cayenne.reflect.FieldEmbeddableDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PersistentDescriptorFactory;
import org.apache.cayenne.reflect.pojo.EnhancedPojoListProperty;
import org.apache.cayenne.reflect.pojo.EnhancedPojoMapProperty;
import org.apache.cayenne.reflect.pojo.EnhancedPojoSetProperty;
import org.apache.cayenne.reflect.pojo.EnhancedPojoToOneProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedPojoDescriptorFactory
extends PersistentDescriptorFactory {
    static final String PERSISTENCE_STATE_FIELD = "$cay_persistenceState";
    protected FaultFactory faultFactory;
    protected EnhancementHelper fieldNameMapper;

    public EnhancedPojoDescriptorFactory(ClassDescriptorMap descriptorMap, FaultFactory faultFactory) {
        super(descriptorMap);
        this.faultFactory = faultFactory;
        this.fieldNameMapper = new EnhancementHelper(null);
    }

    @Override
    protected ClassDescriptor getDescriptor(ObjEntity entity, Class<?> entityClass) {
        try {
            Integer.TYPE.equals(entityClass.getDeclaredField(PERSISTENCE_STATE_FIELD).getType());
        }
        catch (Throwable th) {
            return null;
        }
        return super.getDescriptor(entity, entityClass);
    }

    @Override
    protected void createToManyListProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), List.class);
        EnhancedPojoListProperty property = new EnhancedPojoListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManyMapProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Map.class);
        Accessor mapKeyAccessor = this.createMapKeyAccessor(relationship, targetDescriptor);
        EnhancedPojoMapProperty property = new EnhancedPojoMapProperty(descriptor, targetDescriptor, accessor, reverseName, mapKeyAccessor);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManySetProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Set.class);
        EnhancedPojoSetProperty property = new EnhancedPojoSetProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToManyCollectionProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), Collection.class);
        EnhancedPojoListProperty property = new EnhancedPojoListProperty(descriptor, targetDescriptor, accessor, reverseName);
        descriptor.addDeclaredProperty(property);
    }

    @Override
    protected void createToOneProperty(PersistentDescriptor descriptor, ObjRelationship relationship) {
        ClassDescriptor targetDescriptor = this.descriptorMap.getDescriptor(relationship.getTargetEntityName());
        String reverseName = relationship.getReverseRelationshipName();
        Accessor accessor = this.createAccessor(descriptor, relationship.getName(), targetDescriptor.getObjectClass());
        descriptor.addDeclaredProperty(new EnhancedPojoToOneProperty(descriptor, targetDescriptor, accessor, reverseName, this.faultFactory.getToOneFault()));
    }

    @Override
    protected EmbeddableDescriptor createEmbeddableDescriptor(EmbeddedAttribute embeddedAttribute) {
        return new FieldEmbeddableDescriptor(embeddedAttribute.getEmbeddable(), this.fieldNameMapper.getPropertyField("owner"), this.fieldNameMapper.getPropertyField("embeddedProperty"));
    }
}

