/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.Collection;
import java.util.Iterator;
import org.apache.cayenne.access.jdbc.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.jdbc.EJBQLPathTranslator;
import org.apache.cayenne.access.jdbc.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;

class EJBQLGroupByTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private int itemCount;

    EJBQLGroupByTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    public boolean visitIdentifier(EJBQLExpression expression) {
        if (this.itemCount++ > 0) {
            this.context.append(',');
        }
        expression.visit(this.context.getTranslatorFactory().getIdentifierColumnsTranslator(this.context));
        return false;
    }

    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        if (this.itemCount++ > 0) {
            this.context.append(',');
        }
        EJBQLPathTranslator childVisitor = new EJBQLPathTranslator(this.context){

            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                throw new EJBQLException("Can't GROUP BY on multi-column paths or objects");
            }

            public boolean visitIdentificationVariable(EJBQLExpression expression) {
                String idVariableAbsolutePath = this.idPath + "." + expression.getText();
                ClassDescriptor descriptor = EJBQLGroupByTranslator.this.context.getEntityDescriptor(idVariableAbsolutePath);
                if (descriptor != null) {
                    this.lastAlias = EJBQLGroupByTranslator.this.context.getTableAlias(idVariableAbsolutePath, descriptor.getEntity().getDbEntity().getFullyQualifiedName());
                }
                this.lastPathComponent = expression.getText();
                return true;
            }

            protected void processTerminatingRelationship(ObjRelationship relationship) {
                Collection<DbAttribute> dbAttr = ((ObjEntity)relationship.getTargetEntity()).getDbEntity().getAttributes();
                DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
                DbEntity table = (DbEntity)dbRelationship.getTargetEntity();
                Iterator<DbAttribute> it = dbAttr.iterator();
                String alias = this.lastAlias != null ? this.lastAlias : EJBQLGroupByTranslator.this.context.getTableAlias(this.idPath, table.getFullyQualifiedName());
                boolean first = true;
                while (it.hasNext()) {
                    EJBQLGroupByTranslator.this.context.append(!first ? ", " : " ");
                    DbAttribute dbAttribute = it.next();
                    EJBQLGroupByTranslator.this.context.append(alias).append('.').append(dbAttribute.getName());
                    first = false;
                }
            }
        };
        expression.visit(childVisitor);
        return false;
    }
}

