/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.dba.AutoAdapter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.log.JdbcEventLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDbAdapterFactory
implements DbAdapterFactory {
    @Inject
    protected Injector injector;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected AdhocObjectFactory objectFactory;
    protected List<DbAdapterDetector> detectors;

    public DefaultDbAdapterFactory(@Inject(value="cayenne.server.adapter_detectors") List<DbAdapterDetector> detectors) {
        if (detectors == null) {
            throw new NullPointerException("Null detectors list");
        }
        this.detectors = detectors;
    }

    @Override
    public DbAdapter createAdapter(DataNodeDescriptor nodeDescriptor, final DataSource dataSource) throws Exception {
        String adapterType = null;
        if (nodeDescriptor != null) {
            adapterType = nodeDescriptor.getAdapterType();
        }
        if (adapterType != null) {
            return this.objectFactory.newInstance(DbAdapter.class, adapterType);
        }
        return new AutoAdapter(new Provider<DbAdapter>(){

            @Override
            public DbAdapter get() {
                return DefaultDbAdapterFactory.this.detectAdapter(dataSource);
            }
        }, this.jdbcEventLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DbAdapter detectAdapter(DataSource dataSource) {
        DbAdapter dbAdapter;
        if (this.detectors.isEmpty()) {
            return this.defaultAdapter();
        }
        Connection c = dataSource.getConnection();
        try {
            dbAdapter = this.detectAdapter(c.getMetaData());
        }
        catch (Throwable throwable) {
            try {
                try {
                    c.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new CayenneRuntimeException("Error detecting database type: " + e.getLocalizedMessage(), (Throwable)e, new Object[0]);
            }
        }
        try {
            c.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return dbAdapter;
    }

    protected DbAdapter detectAdapter(DatabaseMetaData metaData) throws SQLException {
        for (int i = this.detectors.size() - 1; i >= 0; --i) {
            DbAdapterDetector detector = this.detectors.get(i);
            DbAdapter adapter = detector.createAdapter(metaData);
            if (adapter == null) continue;
            this.jdbcEventLogger.log("Detected and installed adapter: " + adapter.getClass().getName());
            this.injector.injectMembers(adapter);
            return adapter;
        }
        return this.defaultAdapter();
    }

    protected DbAdapter defaultAdapter() {
        this.jdbcEventLogger.log("Failed to detect database type, using generic adapter");
        return this.objectFactory.newInstance(DbAdapter.class, JdbcAdapter.class.getName());
    }
}

