/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.Scope;
import org.apache.cayenne.di.spi.AfterScopeEnd;
import org.apache.cayenne.di.spi.DefaultScopeProvider;
import org.apache.cayenne.di.spi.ScopeEventBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScope
implements Scope {
    protected Collection<Class<? extends Annotation>> eventTypes;
    protected ConcurrentMap<String, Collection<ScopeEventBinding>> listeners = new ConcurrentHashMap<String, Collection<ScopeEventBinding>>();
    private static final String SPECIAL_EVENT = AfterScopeEnd.class.getName();

    public DefaultScope(Class<? extends Annotation> ... customEventTypes) {
        this.eventTypes = new HashSet<Class<? extends Annotation>>();
        this.eventTypes.add(BeforeScopeEnd.class);
        this.eventTypes.add(AfterScopeEnd.class);
        if (customEventTypes != null) {
            for (Class<? extends Annotation> type : customEventTypes) {
                this.eventTypes.add(type);
            }
        }
        for (Class clazz : this.eventTypes) {
            this.listeners.put(clazz.getName(), new ConcurrentLinkedQueue());
        }
    }

    public void shutdown() {
        this.postScopeEvent(BeforeScopeEnd.class, new Object[0]);
        this.postScopeEvent(AfterScopeEnd.class, new Object[0]);
    }

    public void addScopeEventListener(Object object) {
        for (Method method : object.getClass().getMethods()) {
            for (Class<? extends Annotation> annotationType : this.eventTypes) {
                if (!method.isAnnotationPresent(annotationType)) continue;
                String typeName = annotationType.getName();
                Collection eventListeners = (Collection)this.listeners.get(typeName);
                eventListeners.add(new ScopeEventBinding(object, method));
            }
        }
    }

    public void removeScopeEventListener(Object object) {
        for (Map.Entry entry : this.listeners.entrySet()) {
            if (SPECIAL_EVENT.equals(entry.getKey())) continue;
            Iterator it = ((Collection)entry.getValue()).iterator();
            while (it.hasNext()) {
                ScopeEventBinding binding = (ScopeEventBinding)it.next();
                if (binding.getObject() != object) continue;
                it.remove();
            }
        }
    }

    public void postScopeEvent(Class<? extends Annotation> type, Object ... eventParameters) {
        Collection eventListeners = (Collection)this.listeners.get(type.getName());
        if (eventListeners != null) {
            Iterator it = eventListeners.iterator();
            while (it.hasNext()) {
                ScopeEventBinding listener = (ScopeEventBinding)it.next();
                if (listener.onScopeEvent(eventParameters)) continue;
                it.remove();
            }
        }
    }

    @Override
    public <T> Provider<T> scope(Provider<T> unscoped) {
        return new DefaultScopeProvider<T>(this, unscoped);
    }
}

