/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mysql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.EJBQLTranslatorFactory;
import org.apache.cayenne.access.trans.QualifierTranslator;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dba.mysql.MySQLActionBuilder;
import org.apache.cayenne.dba.mysql.MySQLEJBQLTranslatorFactory;
import org.apache.cayenne.dba.mysql.MySQLMergerFactory;
import org.apache.cayenne.dba.mysql.MySQLPkGenerator;
import org.apache.cayenne.dba.mysql.MySQLQualifierTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLAdapter
extends JdbcAdapter {
    static final String DEFAULT_STORAGE_ENGINE = "InnoDB";
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_START = "`";
    static final String MYSQL_QUOTE_SQL_IDENTIFIERS_CHAR_END = "`";
    protected String storageEngine = "InnoDB";
    protected boolean supportsFkConstraints;

    public MySQLAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories);
        this.setSupportsBatchUpdates(true);
        this.setSupportsFkConstraints(true);
        this.setSupportsUniqueConstraints(true);
        this.setSupportsGeneratedKeys(true);
        this.initIdentifiersQuotes();
    }

    void setSupportsFkConstraints(boolean flag) {
        this.supportsFkConstraints = flag;
    }

    @Override
    public void initIdentifiersQuotes() {
        this.identifiersStartQuote = "`";
        this.identifiersEndQuote = "`";
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        MySQLQualifierTranslator translator = new MySQLQualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new MySQLActionBuilder(this, node.getEntityResolver()));
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        StringBuffer buf = new StringBuffer();
        QuotingStrategy context = this.getQuotingStrategy(table.getDataMap().isQuotingSQLIdentifiers());
        buf.append(context.quoteFullyQualifiedName(table));
        return Arrays.asList("SET FOREIGN_KEY_CHECKS=0", "DROP TABLE IF EXISTS " + buf.toString() + " CASCADE", "SET FOREIGN_KEY_CHECKS=1");
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(false, false));
        map.registerType(new ByteArrayType(false, false));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int precision, boolean allowNulls) {
        if (typeName != null) {
            typeName = typeName.toLowerCase();
        }
        if (type == 1111) {
            if ("longblob".equals(typeName)) {
                type = 2004;
            } else if ("mediumblob".equals(typeName)) {
                type = 2004;
            } else if ("blob".equals(typeName)) {
                type = 2004;
            } else if ("tinyblob".equals(typeName)) {
                type = -3;
            } else if ("longtext".equals(typeName)) {
                type = 2005;
            } else if ("mediumtext".equals(typeName)) {
                type = 2005;
            } else if ("text".equals(typeName)) {
                type = 2005;
            } else if ("tinytext".equals(typeName)) {
                type = 12;
            }
        } else if (typeName != null && typeName.endsWith(" unsigned") && (typeName.equals("int unsigned") || typeName.equals("integer unsigned") || typeName.equals("mediumint unsigned"))) {
            type = -5;
        }
        return super.buildAttribute(name, typeName, type, size, precision, allowNulls);
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new MySQLPkGenerator(this);
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        MySQLEJBQLTranslatorFactory translatorFactory = new MySQLEJBQLTranslatorFactory();
        translatorFactory.setCaseInsensitive(this.caseInsensitiveCollations);
        return translatorFactory;
    }

    @Override
    public String createTable(DbEntity entity) {
        String ddlSQL = super.createTable(entity);
        if (this.storageEngine != null) {
            ddlSQL = ddlSQL + " ENGINE=" + this.storageEngine;
        }
        return ddlSQL;
    }

    @Override
    protected void createTableAppendPKClause(StringBuffer sqlBuffer, DbEntity entity) {
        boolean status = entity.getDataMap() != null && entity.getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        ArrayList<DbAttribute> pkList = new ArrayList<DbAttribute>(entity.getPrimaryKeys());
        Collections.sort(pkList, new PKComparator());
        Iterator pkit = pkList.iterator();
        if (pkit.hasNext()) {
            sqlBuffer.append(", PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    sqlBuffer.append(", ");
                }
                DbAttribute dbAttribute = (DbAttribute)pkit.next();
                sqlBuffer.append(context.quoteString(dbAttribute.getName()));
            }
            sqlBuffer.append(')');
        }
        if (this.supportsFkConstraints) {
            for (Relationship relationship : entity.getRelationships()) {
                DbRelationship relationship2 = (DbRelationship)relationship;
                if (relationship2.getJoins().size() <= 0 || !relationship2.isToPK() || relationship2.isToDependentPK()) continue;
                sqlBuffer.append(", KEY (");
                Iterator<DbAttribute> columns = relationship2.getSourceAttributes().iterator();
                DbAttribute column = columns.next();
                sqlBuffer.append(context.quoteString(column.getName()));
                while (columns.hasNext()) {
                    column = columns.next();
                    sqlBuffer.append(", ").append(context.quoteString(column.getName()));
                }
                sqlBuffer.append(")");
            }
        }
    }

    @Override
    public void createTableAppendColumn(StringBuffer sqlBuffer, DbAttribute column) {
        boolean status = column.getEntity().getDataMap() != null && column.getEntity().getDataMap().isQuotingSQLIdentifiers();
        QuotingStrategy context = this.getQuotingStrategy(status);
        String[] types = this.externalTypesForJdbcType(column.getType());
        if (types == null || types.length == 0) {
            String entityName = column.getEntity() != null ? ((DbEntity)column.getEntity()).getFullyQualifiedName() : "<null>";
            throw new CayenneRuntimeException("Undefined type for attribute '" + entityName + "." + column.getName() + "': " + column.getType(), new Object[0]);
        }
        String type = types[0];
        sqlBuffer.append(context.quoteString(column.getName()));
        sqlBuffer.append(' ').append(type);
        if (TypesMapping.supportsLength(column.getType())) {
            int scale;
            int len = column.getMaxLength();
            int n = scale = TypesMapping.isDecimal(column.getType()) ? column.getScale() : -1;
            if (scale > len) {
                scale = -1;
            }
            if (len > 0) {
                sqlBuffer.append('(').append(len);
                if (scale >= 0) {
                    sqlBuffer.append(", ").append(scale);
                }
                sqlBuffer.append(')');
            }
        }
        sqlBuffer.append(column.isMandatory() ? " NOT NULL" : " NULL");
        if (column.isGenerated()) {
            sqlBuffer.append(" AUTO_INCREMENT");
        }
    }

    @Override
    public MergerFactory mergerFactory() {
        return new MySQLMergerFactory();
    }

    public String getStorageEngine() {
        return this.storageEngine;
    }

    public void setStorageEngine(String engine) {
        this.storageEngine = engine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class PKComparator
    implements Comparator<DbAttribute> {
        PKComparator() {
        }

        @Override
        public int compare(DbAttribute a1, DbAttribute a2) {
            if (a1.isGenerated() != a2.isGenerated()) {
                return a1.isGenerated() ? -1 : 1;
            }
            return a1.getName().compareTo(a2.getName());
        }
    }
}

