/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlite;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.cayenne.access.types.CalendarType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.sqlite.SQLiteDateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SQLiteCalendarType
implements ExtendedType {
    protected ExtendedType delegateCalendarType;
    protected ExtendedType delegateDateType;

    public <T extends Calendar> SQLiteCalendarType(Class<T> calendarClass) {
        this.delegateCalendarType = new CalendarType<T>(calendarClass);
        this.delegateDateType = new SQLiteDateType();
    }

    @Override
    public String getClassName() {
        return this.delegateCalendarType.getClassName();
    }

    @Override
    public Object materializeObject(CallableStatement rs, int index, int type) throws Exception {
        Date date = (Date)this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public Object materializeObject(ResultSet rs, int index, int type) throws Exception {
        Date date = (Date)this.delegateDateType.materializeObject(rs, index, type);
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, Object value, int pos, int type, int precision) throws Exception {
        this.delegateCalendarType.setJdbcObject(statement, value, pos, type, precision);
    }
}

