/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.reflect.Field;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.InjectionStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FieldInjectingProvider<T>
implements Provider<T> {
    private DefaultInjector injector;
    private Provider<T> delegate;

    FieldInjectingProvider(Provider<T> delegate, DefaultInjector injector) {
        this.delegate = delegate;
        this.injector = injector;
    }

    @Override
    public T get() throws ConfigurationException {
        T object = this.delegate.get();
        this.injectMembers(object, object.getClass());
        return object;
    }

    private void injectMembers(T object, Class<?> type) {
        if (type == null) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            this.injectMember(object, field, inject.value());
        }
        this.injectMembers(object, type.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectMember(Object object, Field field, String bindingName) {
        Provider<?> value;
        InjectionStack stack = this.injector.getInjectionStack();
        Class<?> fieldType = field.getType();
        if (Provider.class.equals(fieldType)) {
            Class<?> objectClass = DIUtil.parameterClass(field.getGenericType());
            if (objectClass == null) {
                throw new ConfigurationException("Provider field %s.%s of type %s must be parameterized to be usable for injection", field.getDeclaringClass().getName(), field.getName(), fieldType.getName());
            }
            value = this.injector.getProvider(Key.get(objectClass, bindingName));
        } else {
            Key<?> key = Key.get(fieldType, bindingName);
            stack.push(key);
            try {
                value = this.injector.getInstance(key);
            }
            finally {
                stack.pop();
            }
        }
        field.setAccessible(true);
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            String message = String.format("Error injecting into field %s.%s of type %s", field.getDeclaringClass().getName(), field.getName(), fieldType.getName());
            throw new ConfigurationException(message, (Throwable)e, new Object[0]);
        }
    }
}

