/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.BaseContext;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelListener;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Fault;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContextDelegate;
import org.apache.cayenne.access.DataContextMergeHandler;
import org.apache.cayenne.access.DataContextQueryAction;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.NoopDelegate;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.ObjectStoreGraphDiff;
import org.apache.cayenne.access.ObjectsFromDataRowsQuery;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.access.Transaction;
import org.apache.cayenne.access.TransactionResultIteratorDecorator;
import org.apache.cayenne.access.util.IteratedSelectObserver;
import org.apache.cayenne.cache.NestedQueryCache;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.ChildDiffLoader;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.graph.GraphManager;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.NamedQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.EventUtil;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataContext
extends BaseContext {
    private DataContextDelegate delegate;
    protected boolean usingSharedSnaphsotCache;
    protected ObjectStore objectStore;
    protected transient DataContextMergeHandler mergeHandler;

    public DataContext() {
        this(null, null);
    }

    public DataContext(DataChannel channel, ObjectStore objectStore) {
        if (objectStore != null) {
            this.objectStore = objectStore;
            objectStore.setContext(this);
        }
        if (channel != null) {
            this.attachToChannel(channel);
        }
        if (objectStore != null) {
            DataDomain domain = this.getParentDataDomain();
            this.usingSharedSnaphsotCache = domain != null && objectStore.getDataRowCache() == domain.getSharedSnapshotCache();
        }
    }

    @Override
    @Deprecated
    public ObjectContext createChildContext() {
        ObjectStore objectStore = new ObjectStore();
        DataContext child = new DataContext(this, objectStore);
        if (this.queryCache != null) {
            child.setQueryCache(new NestedQueryCache(this.queryCache));
        }
        child.setValidatingObjectsOnCommit(this.isValidatingObjectsOnCommit());
        child.usingSharedSnaphsotCache = this.isUsingSharedSnapshotCache();
        return child;
    }

    @Override
    protected void attachToChannel(DataChannel channel) {
        DataRowStore cache;
        EventManager eventManager;
        super.attachToChannel(channel);
        if (this.mergeHandler != null) {
            this.mergeHandler.setActive(false);
            this.mergeHandler = null;
        }
        if ((eventManager = channel.getEventManager()) != null) {
            this.mergeHandler = new DataContextMergeHandler(this);
            EventUtil.listenForChannelEvents(channel, (DataChannelListener)this.mergeHandler);
        }
        if (!this.usingSharedSnaphsotCache && this.getObjectStore() != null && (cache = this.getObjectStore().getDataRowCache()) != null) {
            cache.setEventManager(eventManager);
        }
    }

    public DataDomain getParentDataDomain() {
        this.attachToRuntimeIfNeeded();
        if (this.channel == null) {
            return null;
        }
        if (this.channel instanceof DataDomain) {
            return (DataDomain)this.channel;
        }
        List response = this.channel.onQuery(this, new DataDomainQuery()).firstList();
        if (response != null && response.size() > 0 && response.get(0) instanceof DataDomain) {
            return (DataDomain)response.get(0);
        }
        return null;
    }

    public void setDelegate(DataContextDelegate delegate) {
        this.delegate = delegate;
    }

    public DataContextDelegate getDelegate() {
        return this.delegate;
    }

    DataContextDelegate nonNullDelegate() {
        return this.delegate != null ? this.delegate : NoopDelegate.noopDelegate;
    }

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    @Override
    public boolean hasChanges() {
        return this.getObjectStore().hasChanges();
    }

    @Override
    public Collection<?> newObjects() {
        return this.getObjectStore().objectsInState(2);
    }

    @Override
    public Collection<?> deletedObjects() {
        return this.getObjectStore().objectsInState(6);
    }

    @Override
    public Collection<?> modifiedObjects() {
        return this.getObjectStore().objectsInState(4);
    }

    @Override
    public Collection<?> uncommittedObjects() {
        int len = this.getObjectStore().registeredObjectsCount();
        if (len == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Persistent> objects = new ArrayList<Persistent>(len > 100 ? len / 2 : len);
        Iterator it = this.getObjectStore().getObjectIterator();
        while (it.hasNext()) {
            Persistent object = (Persistent)it.next();
            int state = object.getPersistenceState();
            if (state != 4 && state != 2 && state != 6) continue;
            objects.add(object);
        }
        return objects;
    }

    public DataRow currentSnapshot(final Persistent object) {
        if (object.getPersistenceState() == 5 && object.getObjectContext() != null) {
            return this.getObjectStore().getSnapshot(object.getObjectId());
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        final DataRow snapshot = new DataRow(10);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitAttribute(AttributeProperty property) {
                ObjAttribute objAttr = property.getAttribute();
                snapshot.put(objAttr.getDbAttributePath(), property.readPropertyDirectly(object));
                return true;
            }

            public boolean visitToMany(ToManyProperty property) {
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                ObjRelationship rel = property.getRelationship();
                if (rel.isSourceIndependentFromTargetChange()) {
                    return true;
                }
                Object targetObject = property.readPropertyDirectly(object);
                if (targetObject == null) {
                    return true;
                }
                if (targetObject instanceof Fault) {
                    DataRow storedSnapshot = DataContext.this.getObjectStore().getSnapshot(object.getObjectId());
                    if (storedSnapshot == null) {
                        throw new CayenneRuntimeException("No matching objects found for ObjectId " + object.getObjectId() + ". Object may have been deleted externally.", new Object[0]);
                    }
                    DbRelationship dbRel = rel.getDbRelationships().get(0);
                    for (DbJoin join : dbRel.getJoins()) {
                        String key = join.getSourceName();
                        snapshot.put(key, storedSnapshot.get(key));
                    }
                    return true;
                }
                Persistent target = (Persistent)targetObject;
                Map<String, Object> idParts = target.getObjectId().getIdSnapshot();
                if (idParts.isEmpty()) {
                    return true;
                }
                DbRelationship dbRel = rel.getDbRelationships().get(0);
                Map<String, Object> fk = dbRel.srcFkSnapshotWithTargetSnapshot(idParts);
                snapshot.putAll(fk);
                return true;
            }
        });
        Map<String, Object> thisIdParts = object.getObjectId().getIdSnapshot();
        if (thisIdParts != null) {
            for (Map.Entry<String, Object> entry : thisIdParts.entrySet()) {
                String nextKey = entry.getKey();
                if (snapshot.containsKey(nextKey)) continue;
                snapshot.put(nextKey, entry.getValue());
            }
        }
        return snapshot;
    }

    public List objectsFromDataRows(ClassDescriptor descriptor, List<? extends DataRow> dataRows) {
        if (this.getObjectStore().getDataRowCache() == null) {
            return this.objectsFromDataRowsFromParentContext(descriptor, dataRows);
        }
        return new ObjectResolver(this, descriptor, true).synchronizedObjectsFromDataRows(dataRows);
    }

    private List objectsFromDataRowsFromParentContext(ClassDescriptor descriptor, List<? extends DataRow> dataRows) {
        return this.getChannel().onQuery(this, new ObjectsFromDataRowsQuery(descriptor, dataRows)).firstList();
    }

    @Deprecated
    public <T extends DataObject> T objectFromDataRow(Class<T> objectClass, DataRow dataRow, boolean refresh) {
        return this.objectFromDataRow(objectClass, dataRow);
    }

    public <T extends DataObject> T objectFromDataRow(Class<T> objectClass, DataRow dataRow) {
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(objectClass);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped Java class: " + objectClass, new Object[0]);
        }
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entity.getName());
        List list = this.objectsFromDataRows(descriptor, Collections.singletonList(dataRow));
        return (T)((DataObject)list.get(0));
    }

    @Deprecated
    public DataObject objectFromDataRow(String entityName, DataRow dataRow, boolean refresh) {
        return this.objectFromDataRow(entityName, dataRow);
    }

    public DataObject objectFromDataRow(String entityName, DataRow dataRow) {
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entityName);
        List list = this.objectsFromDataRows(descriptor, Collections.singletonList(dataRow));
        return (DataObject)list.get(0);
    }

    @Override
    public <T> T newObject(Class<T> persistentClass) {
        if (persistentClass == null) {
            throw new NullPointerException("Null 'persistentClass'");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(persistentClass);
        if (entity == null) {
            throw new IllegalArgumentException("Class is not mapped with Cayenne: " + persistentClass.getName());
        }
        return (T)this.newObject(entity.getName());
    }

    public Persistent newObject(String entityName) {
        Persistent object;
        ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(entityName);
        if (descriptor == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entityName);
        }
        try {
            object = (Persistent)descriptor.createObject();
        }
        catch (Exception ex) {
            throw new CayenneRuntimeException("Error instantiating object.", (Throwable)ex, new Object[0]);
        }
        descriptor.injectValueHolders(object);
        ObjectId id = new ObjectId(entityName);
        object.setObjectId(id);
        this.injectInitialValue(object);
        return object;
    }

    @Override
    public void registerNewObject(Object object) {
        ClassDescriptor descriptor;
        if (object == null) {
            throw new NullPointerException("Can't register null object.");
        }
        ObjEntity entity = this.getEntityResolver().lookupObjEntity(object);
        if (entity == null) {
            throw new IllegalArgumentException("Can't find ObjEntity for Persistent class: " + object.getClass().getName() + ", class is likely not mapped.");
        }
        final Persistent persistent = (Persistent)object;
        if (persistent.getObjectId() != null) {
            if (persistent.getObjectContext() == this) {
                return;
            }
            if (persistent.getObjectContext() != null) {
                throw new IllegalStateException("Persistent is already registered with another DataContext. Try using 'localObjects()' instead.");
            }
        } else {
            persistent.setObjectId(new ObjectId(entity.getName()));
        }
        if ((descriptor = this.getEntityResolver().getClassDescriptor(entity.getName())) == null) {
            throw new IllegalArgumentException("Invalid entity name: " + entity.getName());
        }
        this.injectInitialValue(object);
        descriptor.visitProperties(new PropertyVisitor(){

            public boolean visitToMany(ToManyProperty property) {
                property.injectValueHolder(persistent);
                if (!property.isFault(persistent)) {
                    Object value = property.readProperty(persistent);
                    Set collection = value instanceof Map ? ((Map)value).entrySet() : (Set)value;
                    for (Object e : collection) {
                        if (!(e instanceof Persistent)) continue;
                        Persistent targetDO = (Persistent)e;
                        DataContext.this.registerNewObject(targetDO);
                        DataContext.this.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), property.getName());
                    }
                }
                return true;
            }

            public boolean visitToOne(ToOneProperty property) {
                Object target = property.readPropertyDirectly(persistent);
                if (target instanceof Persistent) {
                    Persistent targetDO = (Persistent)target;
                    DataContext.this.registerNewObject(targetDO);
                    DataContext.this.getObjectStore().arcCreated(persistent.getObjectId(), targetDO.getObjectId(), property.getName());
                }
                return true;
            }

            public boolean visitAttribute(AttributeProperty property) {
                return true;
            }
        });
    }

    public void unregisterObjects(Collection dataObjects) {
        this.getObjectStore().objectsUnregistered(dataObjects);
    }

    @Override
    public void rollbackChangesLocally() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        }
    }

    @Override
    public void rollbackChanges() {
        if (this.objectStore.hasChanges()) {
            ObjectStoreGraphDiff diff = this.getObjectStore().getChanges();
            if (this.channel != null) {
                this.channel.onSync(this, diff, 3);
            }
            this.getObjectStore().objectsRolledBack();
            this.fireDataChannelRolledback(this, diff);
        } else if (this.channel != null) {
            this.channel.onSync(this, new CompoundDiff(), 3);
        }
    }

    @Override
    public void commitChangesToParent() {
        this.flushToParent(false);
    }

    @Override
    public void commitChanges() throws CayenneRuntimeException {
        this.flushToParent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GraphDiff onContextFlush(ObjectContext originatingContext, GraphDiff changes, boolean cascade) {
        boolean childContext = this != originatingContext && changes != null;
        try {
            if (childContext) {
                this.getObjectStore().childContextSyncStarted();
                changes.apply(new ChildDiffLoader(this));
                this.fireDataChannelChanged(originatingContext, changes);
            }
            GraphDiff graphDiff = cascade ? this.flushToParent(true) : new CompoundDiff();
            return graphDiff;
        }
        finally {
            if (childContext) {
                this.getObjectStore().childContextSyncStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GraphDiff flushToParent(boolean cascade) {
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Cannot commit changes - channel is not set.", new Object[0]);
        }
        int syncType = cascade ? 2 : 1;
        ObjectStore objectStore = this.getObjectStore();
        GraphDiff parentChanges = null;
        ObjectStore objectStore2 = objectStore;
        synchronized (objectStore2) {
            boolean noop;
            ObjectStoreGraphDiff changes = objectStore.getChanges();
            boolean bl = noop = this.isValidatingObjectsOnCommit() ? changes.validateAndCheckNoop() : changes.isNoop();
            if (noop) {
                objectStore.postprocessAfterPhantomCommit();
            } else {
                try {
                    parentChanges = this.getChannel().onSync(this, changes, syncType);
                    if (objectStore.hasChanges()) {
                        objectStore.postprocessAfterCommit(parentChanges);
                    }
                    this.fireDataChannelCommitted(this, changes);
                }
                catch (CayenneRuntimeException ex) {
                    Throwable unwound = Util.unwindException(ex);
                    if (unwound instanceof CayenneRuntimeException) {
                        throw (CayenneRuntimeException)unwound;
                    }
                    throw new CayenneRuntimeException("Commit Exception", unwound, new Object[0]);
                }
            }
            CompoundDiff diff = new CompoundDiff();
            diff.addAll(objectStore.getLifecycleEventInducedChanges());
            if (parentChanges != null) {
                diff.add(parentChanges);
            }
            if (!diff.isNoop()) {
                this.fireDataChannelCommitted(this.getChannel(), diff);
            }
            return diff;
        }
    }

    public ResultIterator performIteratedQuery(Query query) throws CayenneException {
        ResultIterator result;
        if (Transaction.getThreadTransaction() != null) {
            return this.internalPerformIteratedQuery(query);
        }
        Transaction tx = this.getParentDataDomain().createTransaction();
        Transaction.bindThreadTransaction(tx);
        try {
            result = this.internalPerformIteratedQuery(query);
        }
        catch (Exception e) {
            Transaction.bindThreadTransaction(null);
            tx.setRollbackOnly();
            throw new CayenneException(e);
        }
        finally {
            if (tx.getStatus() == 7) {
                try {
                    tx.rollback();
                }
                catch (Exception rollbackEx) {}
            }
        }
        return new TransactionResultIteratorDecorator(result, tx);
    }

    ResultIterator internalPerformIteratedQuery(Query query) throws CayenneException {
        IteratedSelectObserver observer = new IteratedSelectObserver();
        this.getParentDataDomain().performQueries(Collections.singletonList(query), observer);
        return observer.getResultIterator();
    }

    @Override
    public QueryResponse performGenericQuery(Query query) {
        query = this.nonNullDelegate().willPerformGenericQuery(this, query);
        if (query == null) {
            return new GenericResponse();
        }
        if (this.getChannel() == null) {
            throw new CayenneRuntimeException("Can't run query - parent DataChannel is not set.", new Object[0]);
        }
        return this.onQuery(this, query);
    }

    @Override
    public List performQuery(Query query) {
        query = this.nonNullDelegate().willPerformQuery(this, query);
        if (query == null) {
            return new ArrayList(1);
        }
        List result = this.onQuery(this, query).firstList();
        return result != null ? result : new ArrayList(1);
    }

    @Override
    public QueryResponse onQuery(ObjectContext context, Query query) {
        return new DataContextQueryAction(this, context, query).execute();
    }

    public int[] performNonSelectingQuery(Query query) {
        int[] count = this.performGenericQuery(query).firstUpdateCount();
        return count != null ? count : new int[]{};
    }

    public int[] performNonSelectingQuery(String queryName) {
        return this.performNonSelectingQuery(new NamedQuery(queryName));
    }

    public int[] performNonSelectingQuery(String queryName, Map<String, ?> parameters) {
        return this.performNonSelectingQuery(new NamedQuery(queryName, parameters));
    }

    public List<?> performQuery(String queryName, boolean expireCachedLists) {
        return this.performQuery(queryName, Collections.EMPTY_MAP, expireCachedLists);
    }

    public List<?> performQuery(String queryName, Map parameters, boolean expireCachedLists) {
        NamedQuery query = new NamedQuery(queryName, parameters);
        query.setForceNoCache(expireCachedLists);
        return this.performQuery(query);
    }

    public boolean isUsingSharedSnapshotCache() {
        return this.usingSharedSnaphsotCache;
    }

    public void setUsingSharedSnapshotCache(boolean flag) {
        this.usingSharedSnaphsotCache = flag;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (!this.isUsingSharedSnapshotCache()) {
            out.writeObject(this.objectStore.getDataRowCache());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isUsingSharedSnapshotCache()) {
            DataRowStore cache = (DataRowStore)in.readObject();
            this.objectStore.setDataRowCache(cache);
        }
        ObjectStore objectStore = this.getObjectStore();
        synchronized (objectStore) {
            Iterator it = this.objectStore.getObjectIterator();
            while (it.hasNext()) {
                Persistent object = (Persistent)it.next();
                object.setObjectContext(this);
            }
        }
    }

    @Override
    public GraphManager getGraphManager() {
        return this.objectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Persistent findOrCreateObject(ObjectId id) {
        if (id == null) {
            throw new IllegalArgumentException("Null ObjectId");
        }
        GraphManager graphManager = this.getGraphManager();
        synchronized (graphManager) {
            Persistent cachedObject = (Persistent)this.getGraphManager().getNode(id);
            if (cachedObject != null) {
                int state = cachedObject.getPersistenceState();
                if (state != 4 && state != 6) {
                    ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
                    descriptor.injectValueHolders(cachedObject);
                }
                return cachedObject;
            }
            ClassDescriptor descriptor = this.getEntityResolver().getClassDescriptor(id.getEntityName());
            Persistent localObject = (Persistent)descriptor.createObject();
            localObject.setObjectContext(this);
            localObject.setObjectId(id);
            this.getGraphManager().registerNode(id, localObject);
            localObject.setPersistenceState(5);
            return localObject;
        }
    }

    @Override
    protected void fireDataChannelChanged(Object postedBy, GraphDiff changes) {
        super.fireDataChannelChanged(postedBy, changes);
    }
}

