/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.TraversalHelper;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EmbeddedAttribute;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.map.Relationship;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.AttributeProperty;
import org.apache.cayenne.reflect.AttributePropertyDecorator;
import org.apache.cayenne.reflect.BeanAccessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.ClassDescriptorFactory;
import org.apache.cayenne.reflect.ClassDescriptorMap;
import org.apache.cayenne.reflect.EmbeddableDescriptor;
import org.apache.cayenne.reflect.EmbeddedFieldAccessor;
import org.apache.cayenne.reflect.FieldAccessor;
import org.apache.cayenne.reflect.FieldEmbeddableDescriptor;
import org.apache.cayenne.reflect.IdMapKeyAccessor;
import org.apache.cayenne.reflect.PersistentDescriptor;
import org.apache.cayenne.reflect.PropertyAccessor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.PropertyVisitor;
import org.apache.cayenne.reflect.SimpleAttributeProperty;
import org.apache.cayenne.reflect.ToManyProperty;
import org.apache.cayenne.reflect.ToOneProperty;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentDescriptorFactory
implements ClassDescriptorFactory {
    protected ClassDescriptorMap descriptorMap;

    public PersistentDescriptorFactory(ClassDescriptorMap descriptorMap) {
        this.descriptorMap = descriptorMap;
    }

    @Override
    public ClassDescriptor getDescriptor(String entityName) {
        ObjEntity entity = this.descriptorMap.getResolver().getObjEntity(entityName);
        if (entity == null) {
            throw new CayenneRuntimeException("Unmapped entity: " + entityName, new Object[0]);
        }
        Class<?> entityClass = entity.getJavaClass();
        return this.getDescriptor(entity, entityClass);
    }

    protected ClassDescriptor getDescriptor(ObjEntity entity, Class<?> entityClass) {
        String superEntityName = entity.getSuperEntityName();
        ClassDescriptor superDescriptor = superEntityName != null ? this.descriptorMap.getDescriptor(superEntityName) : null;
        PersistentDescriptor descriptor = this.createDescriptor();
        descriptor.setEntity(entity);
        descriptor.setSuperclassDescriptor(superDescriptor);
        descriptor.setObjectClass(entityClass);
        descriptor.setPersistenceStateAccessor(new BeanAccessor(entityClass, "persistenceState", Integer.TYPE));
        for (ObjAttribute attribute : descriptor.getEntity().getDeclaredAttributes()) {
            if (attribute instanceof EmbeddedAttribute) {
                EmbeddedAttribute embedded = (EmbeddedAttribute)attribute;
                for (ObjAttribute objAttribute : embedded.getAttributes()) {
                    this.createEmbeddedAttributeProperty(descriptor, embedded, objAttribute);
                }
                continue;
            }
            if (!(attribute instanceof ObjAttribute)) continue;
            this.createAttributeProperty(descriptor, attribute);
        }
        Iterator<XMLSerializable> i$ = descriptor.getEntity().getDeclaredRelationships().iterator();
        while (i$.hasNext()) {
            ObjRelationship relationship;
            ObjRelationship objRelationship = relationship = (ObjRelationship)i$.next();
            if (((Relationship)relationship).isToMany()) {
                String collectionType = objRelationship.getCollectionType();
                if (collectionType == null || "java.util.List".equals(collectionType)) {
                    this.createToManyListProperty(descriptor, objRelationship);
                    continue;
                }
                if (collectionType.equals("java.util.Map")) {
                    this.createToManyMapProperty(descriptor, objRelationship);
                    continue;
                }
                if (collectionType.equals("java.util.Set")) {
                    this.createToManySetProperty(descriptor, objRelationship);
                    continue;
                }
                if (collectionType.equals("java.util.Collection")) {
                    this.createToManyCollectionProperty(descriptor, objRelationship);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported to-many collection type: " + collectionType);
            }
            this.createToOneProperty(descriptor, objRelationship);
        }
        EntityInheritanceTree inheritanceTree = this.descriptorMap.getResolver().lookupInheritanceTree(descriptor.getEntity().getName());
        descriptor.setEntityInheritanceTree(inheritanceTree);
        this.indexSubclassDescriptors(descriptor, inheritanceTree);
        this.indexQualifiers(descriptor, inheritanceTree);
        this.appendDeclaredRootDbEntity(descriptor, descriptor.getEntity());
        this.indexRootDbEntities(descriptor, inheritanceTree);
        this.indexSuperclassProperties(descriptor);
        return descriptor;
    }

    protected PersistentDescriptor createDescriptor() {
        return new PersistentDescriptor();
    }

    protected void createAttributeProperty(PersistentDescriptor descriptor, ObjAttribute attribute) {
        Class<?> propertyType = attribute.getJavaClass();
        Accessor accessor = this.createAccessor(descriptor, attribute.getName(), propertyType);
        descriptor.addDeclaredProperty(new SimpleAttributeProperty(descriptor, accessor, attribute));
    }

    protected void createEmbeddedAttributeProperty(PersistentDescriptor descriptor, EmbeddedAttribute embeddedAttribute, ObjAttribute attribute) {
        Class<?> embeddableClass = embeddedAttribute.getJavaClass();
        String propertyPath = attribute.getName();
        int lastDot = propertyPath.lastIndexOf(46);
        if (lastDot <= 0 || lastDot == propertyPath.length() - 1) {
            throw new IllegalArgumentException("Invalid embeddable path: " + propertyPath);
        }
        String embeddableName = propertyPath.substring(lastDot + 1);
        EmbeddableDescriptor embeddableDescriptor = this.createEmbeddableDescriptor(embeddedAttribute);
        Accessor embeddedAccessor = this.createAccessor(descriptor, embeddedAttribute.getName(), embeddableClass);
        Accessor embeddedableAccessor = this.createEmbeddableAccessor(embeddableDescriptor, embeddableName, attribute.getJavaClass());
        EmbeddedFieldAccessor accessor = new EmbeddedFieldAccessor(embeddableDescriptor, embeddedAccessor, embeddedableAccessor);
        descriptor.addDeclaredProperty(new SimpleAttributeProperty(descriptor, accessor, attribute));
    }

    protected abstract void createToOneProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected abstract void createToManySetProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected abstract void createToManyMapProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected abstract void createToManyListProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected abstract void createToManyCollectionProperty(PersistentDescriptor var1, ObjRelationship var2);

    protected void indexSubclassDescriptors(PersistentDescriptor descriptor, EntityInheritanceTree inheritanceTree) {
        if (inheritanceTree != null) {
            for (EntityInheritanceTree child : inheritanceTree.getChildren()) {
                ObjEntity childEntity = child.getEntity();
                descriptor.addSubclassDescriptor(childEntity.getClassName(), this.descriptorMap.getDescriptor(childEntity.getName()));
                this.indexSubclassDescriptors(descriptor, child);
            }
        }
    }

    protected void indexRootDbEntities(PersistentDescriptor descriptor, EntityInheritanceTree inheritanceTree) {
        if (inheritanceTree != null) {
            for (EntityInheritanceTree child : inheritanceTree.getChildren()) {
                ObjEntity childEntity = child.getEntity();
                this.appendDeclaredRootDbEntity(descriptor, childEntity);
                this.indexRootDbEntities(descriptor, child);
            }
        }
    }

    private void appendDeclaredRootDbEntity(PersistentDescriptor descriptor, ObjEntity entity) {
        DbEntity dbEntity = entity.getDbEntity();
        if (dbEntity != null) {
            descriptor.addRootDbEntity(dbEntity);
        }
    }

    protected void indexQualifiers(final PersistentDescriptor descriptor, EntityInheritanceTree inheritanceTree) {
        Expression qualifier = inheritanceTree != null ? inheritanceTree.qualifierForEntityAndSubclasses() : descriptor.getEntity().getDeclaredQualifier();
        if (qualifier != null) {
            final HashSet<ObjAttribute> attributes = new HashSet<ObjAttribute>();
            final DbEntity dbEntity = descriptor.getEntity().getDbEntity();
            qualifier.traverse(new TraversalHelper(){

                public void startNode(Expression node, Expression parentNode) {
                    if (node.getType() == 27) {
                        String path = node.getOperand(0).toString();
                        final DbAttribute attribute = (DbAttribute)dbEntity.getAttribute(path);
                        if (attribute != null) {
                            ObjAttribute objectAttribute = descriptor.getEntity().getAttributeForDbAttribute(attribute);
                            if (objectAttribute == null) {
                                objectAttribute = new ObjAttribute(attribute.getName()){

                                    public DbAttribute getDbAttribute() {
                                        return attribute;
                                    }
                                };
                                objectAttribute.setDbAttributePath(attribute.getName());
                                objectAttribute.setType(TypesMapping.getJavaBySqlType(attribute.getType()));
                            }
                            attributes.add(objectAttribute);
                        }
                    } else if (node.getType() == 26) {
                        String path = node.getOperand(0).toString();
                        attributes.add((ObjAttribute)descriptor.getEntity().getAttribute(path));
                    }
                }
            });
            descriptor.setDiscriminatorColumns(attributes);
            descriptor.setEntityQualifier(qualifier);
        }
    }

    protected void indexSuperclassProperties(final PersistentDescriptor descriptor) {
        ClassDescriptor superDescriptor = descriptor.getSuperclassDescriptor();
        if (superDescriptor != null) {
            superDescriptor.visitProperties(new PropertyVisitor(){

                public boolean visitAttribute(AttributeProperty property) {
                    descriptor.addSuperProperty(new AttributePropertyDecorator(descriptor, property));
                    return true;
                }

                public boolean visitToMany(ToManyProperty property) {
                    descriptor.addSuperProperty(property);
                    return true;
                }

                public boolean visitToOne(ToOneProperty property) {
                    descriptor.addSuperProperty(property);
                    return true;
                }
            });
        }
    }

    protected Accessor createAccessor(PersistentDescriptor descriptor, String propertyName, Class<?> propertyType) throws PropertyException {
        return new FieldAccessor(descriptor.getObjectClass(), propertyName, propertyType);
    }

    protected Accessor createMapKeyAccessor(ObjRelationship relationship, ClassDescriptor targetDescriptor) {
        String mapKey = relationship.getMapKey();
        if (mapKey != null) {
            return new PropertyAccessor(targetDescriptor.getProperty(mapKey));
        }
        return IdMapKeyAccessor.SHARED_ACCESSOR;
    }

    protected Accessor createEmbeddableAccessor(EmbeddableDescriptor descriptor, String propertyName, Class<?> propertyType) {
        return new FieldAccessor(descriptor.getObjectClass(), propertyName, propertyType);
    }

    protected EmbeddableDescriptor createEmbeddableDescriptor(EmbeddedAttribute embeddedAttribute) {
        return new FieldEmbeddableDescriptor(embeddedAttribute.getEmbeddable(), "owner", "embeddedProperty");
    }
}

