/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchAction;
import org.apache.cayenne.dba.oracle.Oracle8SQLTemplateAction;
import org.apache.cayenne.dba.oracle.Oracle8SelectAction;
import org.apache.cayenne.dba.oracle.OracleActionBuilder;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleBatchAction;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

class Oracle8ActionBuilder
extends OracleActionBuilder {
    Oracle8ActionBuilder(JdbcAdapter adapter, EntityResolver resolver) {
        super(adapter, resolver);
    }

    public SQLAction sqlAction(SQLTemplate query) {
        return new Oracle8SQLTemplateAction(query, this.adapter, this.getEntityResolver());
    }

    public SQLAction objectSelectAction(SelectQuery query) {
        return new Oracle8SelectAction(query, this.getAdapter(), this.getEntityResolver());
    }

    public SQLAction batchAction(BatchQuery query) {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query)) {
            return new Oracle8LOBBatchAction(query, this.getAdapter());
        }
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.adapter.supportsBatchUpdates();
        OracleBatchAction action = new OracleBatchAction(query, this.adapter, this.getEntityResolver());
        action.setBatch(runningAsBatch);
        return action;
    }
}

