/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.SelectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticLockException
extends CayenneRuntimeException {
    protected String querySQL;
    protected DbEntity rootEntity;
    protected Map qualifierSnapshot;

    public OptimisticLockException(DbEntity rootEntity, String querySQL, Map qualifierSnapshot) {
        super("Optimistic Lock Failure", new Object[0]);
        this.rootEntity = rootEntity;
        this.querySQL = querySQL;
        this.qualifierSnapshot = qualifierSnapshot != null ? qualifierSnapshot : Collections.EMPTY_MAP;
    }

    public Map getQualifierSnapshot() {
        return this.qualifierSnapshot;
    }

    public String getQuerySQL() {
        return this.querySQL;
    }

    public Map<?, ?> getFreshSnapshot(ObjectContext context) {
        Expression qualifier = null;
        for (DbAttribute attribute : this.rootEntity.getPrimaryKeys()) {
            Expression attributeQualifier = ExpressionFactory.matchDbExp(attribute.getName(), this.qualifierSnapshot.get(attribute.getName()));
            qualifier = qualifier != null ? qualifier.andExp(attributeQualifier) : attributeQualifier;
        }
        SelectQuery query = new SelectQuery(this.rootEntity, qualifier);
        query.setFetchingDataRows(true);
        return (Map)Cayenne.objectForQuery(context, query);
    }

    @Override
    public String getMessage() {
        StringBuffer buffer = new StringBuffer(super.getMessage());
        if (this.querySQL != null) {
            buffer.append(", SQL: [").append(this.querySQL.trim()).append("]");
        }
        if (!this.qualifierSnapshot.isEmpty()) {
            buffer.append(", WHERE clause bindings: [");
            Iterator it = this.qualifierSnapshot.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                buffer.append(entry.getKey()).append("=");
                QueryLogger.sqlLiteralForObject(buffer, entry.getValue());
                if (!it.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append("]");
        }
        return buffer.toString();
    }
}

