/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.db2;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.trans.QueryAssembler;
import org.apache.cayenne.access.trans.TrimmingQualifierTranslator;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;

public class DB2QualifierTranslator
extends TrimmingQualifierTranslator {
    public DB2QualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler, trimFunction);
    }

    protected void appendLiteralDirect(Object val, DbAttribute attr, Expression parentExpression) throws IOException {
        boolean castNeeded = false;
        if (parentExpression != null) {
            int type = parentExpression.getType();
            boolean bl = castNeeded = attr != null && (type == 11 || type == 12 || type == 37 || type == 38);
        }
        if (castNeeded) {
            this.out.append("CAST (");
        }
        super.appendLiteralDirect(val, attr, parentExpression);
        if (castNeeded) {
            int jdbcType = attr.getType();
            int len = attr.getMaxLength();
            if (jdbcType == 1 || jdbcType == -1) {
                jdbcType = 12;
                if (len <= 0) {
                    len = 254;
                }
            }
            this.out.append(" AS ");
            String[] types = this.queryAssembler.getAdapter().externalTypesForJdbcType(jdbcType);
            if (types == null || types.length == 0) {
                throw new CayenneRuntimeException("Can't find database type for JDBC type '" + TypesMapping.getSqlNameByType(jdbcType), new Object[0]);
            }
            this.out.append(types[0]);
            if (len > 0 && TypesMapping.supportsLength(jdbcType)) {
                this.out.append("(");
                this.out.append(String.valueOf(len));
                this.out.append(")");
            }
            this.out.append(")");
        }
    }
}

