/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.FaultFailureException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.util.RelationshipFault;
import org.apache.cayenne.util.Util;

public class PersistentObjectHolder
extends RelationshipFault
implements ValueHolder {
    protected boolean fault;
    protected Object value;

    private PersistentObjectHolder() {
        this.fault = true;
    }

    public PersistentObjectHolder(Persistent relationshipOwner, String relationshipName) {
        super(relationshipOwner, relationshipName);
        this.fault = !this.isTransientParent();
    }

    public boolean isFault() {
        return this.fault;
    }

    public void invalidate() {
        this.fault = true;
        this.value = null;
    }

    public Object getValue() throws CayenneRuntimeException {
        if (this.fault) {
            this.resolve();
        }
        return this.value;
    }

    public Object getValueDirectly() throws CayenneRuntimeException {
        return this.value;
    }

    public synchronized Object setValue(Object value) throws CayenneRuntimeException {
        Object oldValue;
        if (this.fault) {
            this.resolve();
        }
        if ((oldValue = this.setValueDirectly(value)) != value) {
            this.relationshipOwner.getObjectContext().propertyChanged(this.relationshipOwner, this.relationshipName, oldValue, value);
            if (oldValue instanceof Persistent) {
                Util.unsetReverse(this.relationshipOwner, this.relationshipName, (Persistent)oldValue);
            }
            if (value instanceof Persistent) {
                Util.setReverse(this.relationshipOwner, this.relationshipName, (Persistent)value);
            }
        }
        return oldValue;
    }

    public Object setValueDirectly(Object value) throws CayenneRuntimeException {
        if (value instanceof Persistent) {
            value = this.connect((Persistent)value);
        }
        Object oldValue = this.value;
        this.value = value;
        this.fault = false;
        return oldValue;
    }

    protected Object connect(Persistent persistent) {
        if (persistent == null) {
            return null;
        }
        if (this.relationshipOwner.getObjectContext() != persistent.getObjectContext()) {
            throw new CayenneRuntimeException("Cannot set object as destination of relationship " + this.relationshipName + " because it is in a different ObjectContext", new Object[0]);
        }
        return persistent;
    }

    protected synchronized void resolve() {
        if (!this.fault) {
            return;
        }
        List objects = this.resolveFromDB();
        if (objects.size() == 0) {
            this.value = null;
        } else if (objects.size() == 1) {
            this.value = objects.get(0);
        } else {
            throw new FaultFailureException("Expected either no objects or a single object, instead fault query resolved to " + objects.size() + " objects.", new Object[0]);
        }
        this.fault = false;
    }
}

