/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.dbsync.SchemaUpdateStrategy;
import org.apache.cayenne.configuration.AdhocObjectFactory;
import org.apache.cayenne.configuration.ConfigurationTree;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataChannelDescriptorLoader;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataDomainLoadException;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataDomainProvider
implements Provider<DataDomain> {
    private static Log logger = LogFactory.getLog(DataDomainProvider.class);
    public static final String FILTERS_LIST = "org.apache.cayenne.configuration.server.DataDomainProvider.filters";
    @Inject
    protected ResourceLocator resourceLocator;
    @Inject
    protected DataChannelDescriptorLoader loader;
    @Inject
    protected RuntimeProperties configurationProperties;
    @Inject
    protected SchemaUpdateStrategy defaultSchemaUpdateStrategy;
    @Inject
    protected DbAdapterFactory adapterFactory;
    @Inject
    protected DataSourceFactory dataSourceFactory;
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject(value="org.apache.cayenne.configuration.server.DataDomainProvider.filters")
    protected List<DataChannelFilter> filters;
    @Inject
    protected Injector injector;

    @Override
    public DataDomain get() throws ConfigurationException {
        try {
            return this.createAndInitDataDomain();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataDomainLoadException("Error loading DataChannel: '%s'", (Throwable)e, e.getMessage());
        }
    }

    protected DataDomain createDataDomain(String name) {
        return new DataDomain(name);
    }

    protected DataDomain createAndInitDataDomain() throws Exception {
        ConfigurationTree<DataChannelDescriptor> tree;
        Collection<Resource> configurations;
        String configurationLocation = this.configurationProperties.get("cayenne.config.location");
        if (configurationLocation == null) {
            throw new DataDomainLoadException("No configuration location available. You can specify when creating Cayenne runtime or via a system property '%s'", "cayenne.config.location");
        }
        long t0 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("starting configuration loading: " + configurationLocation));
        }
        if ((configurations = this.resourceLocator.findResources(configurationLocation)).isEmpty()) {
            throw new DataDomainLoadException("Configuration file \"%s\" is not found.", configurationLocation);
        }
        Resource configurationResource = configurations.iterator().next();
        if (configurations.size() > 1) {
            logger.info((Object)("found " + configurations.size() + " configurations, will use the first one: " + configurationResource.getURL()));
        }
        if (!(tree = this.loader.load(configurationResource)).getLoadFailures().isEmpty()) {
            throw new DataDomainLoadException(tree, "Error loading DataChannelDescriptor", new Object[0]);
        }
        long t1 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("finished configuration loading: " + configurationLocation + " in " + (t1 - t0) + " ms."));
        }
        DataChannelDescriptor descriptor = tree.getRootNode();
        DataDomain dataDomain = this.createDataDomain(descriptor.getName());
        dataDomain.setEntitySorter(this.injector.getInstance(EntitySorter.class));
        dataDomain.setEventManager(this.injector.getInstance(EventManager.class));
        dataDomain.initWithProperties(descriptor.getProperties());
        for (DataMap dataMap : descriptor.getDataMaps()) {
            dataDomain.addDataMap(dataMap);
        }
        dataDomain.getEntityResolver().applyDBLayerDefaults();
        dataDomain.getEntityResolver().applyObjectLayerDefaults();
        for (DataNodeDescriptor nodeDescriptor : descriptor.getNodeDescriptors()) {
            DataNode dataNode = new DataNode(nodeDescriptor.getName());
            dataNode.setDataSourceLocation(nodeDescriptor.getParameters());
            DataSource dataSource = this.dataSourceFactory.getDataSource(nodeDescriptor);
            dataNode.setDataSourceFactory(nodeDescriptor.getDataSourceFactoryType());
            dataNode.setDataSource(dataSource);
            String schemaUpdateStrategyType = nodeDescriptor.getSchemaUpdateStrategyType();
            if (schemaUpdateStrategyType == null) {
                dataNode.setSchemaUpdateStrategy(this.defaultSchemaUpdateStrategy);
                dataNode.setSchemaUpdateStrategyName(this.defaultSchemaUpdateStrategy.getClass().getName());
            } else {
                SchemaUpdateStrategy strategy = this.objectFactory.newInstance(SchemaUpdateStrategy.class, schemaUpdateStrategyType);
                dataNode.setSchemaUpdateStrategyName(schemaUpdateStrategyType);
                dataNode.setSchemaUpdateStrategy(strategy);
            }
            dataNode.setAdapter(this.adapterFactory.createAdapter(nodeDescriptor, dataSource));
            for (String dataMapName : nodeDescriptor.getDataMapNames()) {
                dataNode.addDataMap(dataDomain.getDataMap(dataMapName));
            }
            dataDomain.addNode(dataNode);
        }
        for (DataChannelFilter filter : this.filters) {
            dataDomain.addFilter(filter);
        }
        return dataDomain;
    }
}

