/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.ResultIterator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistinctResultIterator
implements ResultIterator {
    protected ResultIterator wrappedIterator;
    protected Set<Map<String, Object>> fetchedIds;
    protected Object nextDataRow;
    protected DbEntity defaultEntity;
    protected boolean compareFullRows;

    public DistinctResultIterator(ResultIterator wrappedIterator, DbEntity defaultEntity, boolean compareFullRows) throws CayenneException {
        if (wrappedIterator == null) {
            throw new CayenneException("Null wrapped iterator.", new Object[0]);
        }
        if (defaultEntity == null) {
            throw new CayenneException("Null defaultEntity.", new Object[0]);
        }
        this.wrappedIterator = wrappedIterator;
        this.defaultEntity = defaultEntity;
        this.fetchedIds = new HashSet<Map<String, Object>>();
        this.compareFullRows = compareFullRows;
        this.checkNextRow();
    }

    @Override
    public void close() throws CayenneException {
        this.wrappedIterator.close();
    }

    @Override
    public List<?> allRows() throws CayenneException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() throws CayenneException {
        return this.nextDataRow != null;
    }

    @Override
    public Object nextRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.", new Object[0]);
        }
        Object row = this.nextDataRow;
        this.checkNextRow();
        return row;
    }

    @Override
    public void skipRow() throws CayenneException {
        if (!this.hasNextRow()) {
            throw new CayenneException("An attempt to read uninitialized row or past the end of the iterator.", new Object[0]);
        }
        this.checkNextRow();
    }

    void checkNextRow() throws CayenneException {
        if (this.compareFullRows) {
            this.checkNextUniqueRow();
        } else {
            this.checkNextRowWithUniqueId();
        }
    }

    void checkNextUniqueRow() throws CayenneException {
        this.nextDataRow = null;
        while (this.wrappedIterator.hasNextRow()) {
            DataRow next = (DataRow)this.wrappedIterator.nextRow();
            if (!this.fetchedIds.add(next)) continue;
            this.nextDataRow = next;
            break;
        }
    }

    void checkNextRowWithUniqueId() throws CayenneException {
        this.nextDataRow = null;
        while (this.wrappedIterator.hasNextRow()) {
            DataRow next = (DataRow)this.wrappedIterator.nextRow();
            HashMap id = new HashMap();
            for (DbAttribute pk : this.defaultEntity.getPrimaryKeys()) {
                id.put(pk.getName(), next.get(pk.getName()));
            }
            if (!this.fetchedIds.add(id)) continue;
            this.nextDataRow = next;
            break;
        }
    }
}

