/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.AdhocObjectFactory;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.PropertyDataSourceFactory;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.spi.ScopeEventBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelegatingDataSourceFactory
implements DataSourceFactory {
    private static final Log logger = LogFactory.getLog(DelegatingDataSourceFactory.class);
    @Inject
    protected AdhocObjectFactory objectFactory;
    @Inject
    protected RuntimeProperties properties;
    protected Map<DataSource, ScopeEventBinding> managedDataSources = new ConcurrentHashMap<DataSource, ScopeEventBinding>();

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        DataSource dataSource = this.getDataSourceFactory(nodeDescriptor).getDataSource(nodeDescriptor);
        this.attachToScope(dataSource);
        return dataSource;
    }

    @BeforeScopeEnd
    public void shutdown() {
        for (ScopeEventBinding binding : this.managedDataSources.values()) {
            binding.onScopeEvent(new Object[0]);
        }
        this.managedDataSources.clear();
    }

    protected void attachToScope(DataSource dataSource) {
        if (!this.managedDataSources.containsKey(dataSource)) {
            Class<BeforeScopeEnd> annotationType = BeforeScopeEnd.class;
            for (Method method : dataSource.getClass().getMethods()) {
                if (!method.isAnnotationPresent(annotationType)) continue;
                this.managedDataSources.put(dataSource, new ScopeEventBinding(dataSource, method));
                break;
            }
        }
    }

    protected DataSourceFactory getDataSourceFactory(DataNodeDescriptor nodeDescriptor) {
        String typeName = null;
        typeName = this.shouldConfigureDataSourceFromProperties(nodeDescriptor) ? PropertyDataSourceFactory.class.getName() : nodeDescriptor.getDataSourceFactoryType();
        if (typeName == null) {
            if (nodeDescriptor.getDataSourceDescriptor() == null) {
                throw new CayenneRuntimeException("DataNodeDescriptor '%s' has null 'dataSourceFactoryType' and 'dataSourceDescriptor' properties", nodeDescriptor.getName());
            }
            typeName = XMLPoolingDataSourceFactory.class.getName();
        }
        return this.objectFactory.newInstance(DataSourceFactory.class, typeName);
    }

    protected boolean shouldConfigureDataSourceFromProperties(DataNodeDescriptor nodeDescriptor) {
        String channelName = nodeDescriptor.getDataChannelDescriptor() != null ? nodeDescriptor.getDataChannelDescriptor().getName() : null;
        String driver = this.properties.get("cayenne.jdbc.driver");
        if (driver == null && channelName != null) {
            driver = this.properties.get("cayenne.jdbc.driver." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName());
        }
        if (driver == null) {
            return false;
        }
        String url = this.properties.get("cayenne.jdbc.url");
        if (url == null && channelName != null) {
            url = this.properties.get("cayenne.jdbc.url." + nodeDescriptor.getDataChannelDescriptor().getName() + "." + nodeDescriptor.getName());
        }
        if (url == null) {
            return false;
        }
        logger.info((Object)String.format("Found DataSourceFactory system property overrides for URL and Driver of '%s.%s' node. Will ignore project DataSource configuration.", channelName, nodeDescriptor.getName()));
        return true;
    }
}

