/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.query.ScalarResultSegment;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScalarRowReader
implements RowReader<Object> {
    private ExtendedType converter;
    private int index;
    private int type;

    ScalarRowReader(RowDescriptor descriptor, ScalarResultSegment segmentMetadata) {
        int scalarIndex = segmentMetadata.getColumnOffset();
        this.converter = descriptor.getConverters()[scalarIndex];
        this.type = descriptor.getColumns()[scalarIndex].getJdbcType();
        this.index = scalarIndex + 1;
    }

    @Override
    public Object readRow(ResultSet resultSet) throws CayenneException {
        try {
            return this.converter.materializeObject(resultSet, this.index, this.type);
        }
        catch (CayenneException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneException("Exception materializing column.", Util.unwindException(otherex), new Object[0]);
        }
    }

    @Override
    public void setPostProcessor(DataRowPostProcessor postProcessor) {
    }
}

