/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import org.apache.cayenne.configuration.BaseConfigurationNodeVisitor;
import org.apache.cayenne.configuration.ConfigurationNameMapper;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigurationNameMapper
implements ConfigurationNameMapper {
    private static final String CAYENNE_PREFIX = "cayenne-";
    private static final String CAYENNE_SUFFIX = ".xml";
    private static final String DATA_MAP_SUFFIX = ".map.xml";
    protected ConfigurationNodeVisitor<String> nameMapper = new NameMapper();

    @Override
    public String configurationLocation(ConfigurationNode node) {
        return node.acceptVisitor(this.nameMapper);
    }

    @Override
    public String configurationLocation(Class<? extends ConfigurationNode> type, String name) {
        if (DataChannelDescriptor.class.isAssignableFrom(type)) {
            return this.getDataChannelName(name);
        }
        if (DataMap.class.isAssignableFrom(type)) {
            return this.getDataMapName(name);
        }
        throw new IllegalArgumentException("Unrecognized configuration type: " + type.getName());
    }

    @Override
    public String configurationNodeName(Class<? extends ConfigurationNode> type, Resource resource) {
        String path = resource.getURL().getPath();
        if (path == null || path.length() == 0) {
            return null;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            if (lastSlash == path.length() - 1) {
                return null;
            }
            path = path.substring(lastSlash + 1);
        }
        if (DataChannelDescriptor.class.isAssignableFrom(type)) {
            if (!path.startsWith(CAYENNE_PREFIX) || !path.endsWith(CAYENNE_SUFFIX)) {
                return null;
            }
            return path.substring(CAYENNE_PREFIX.length(), path.length() - CAYENNE_SUFFIX.length());
        }
        if (DataMap.class.isAssignableFrom(type)) {
            if (!path.endsWith(DATA_MAP_SUFFIX)) {
                return null;
            }
            return path.substring(0, path.length() - DATA_MAP_SUFFIX.length());
        }
        throw new IllegalArgumentException("Unrecognized configuration type: " + type.getName());
    }

    protected String getDataChannelName(String name) {
        if (name == null) {
            throw new NullPointerException("Null DataChannelDescriptor name");
        }
        return CAYENNE_PREFIX + name + CAYENNE_SUFFIX;
    }

    protected String getDataMapName(String name) {
        if (name == null) {
            throw new NullPointerException("Null DataMap name");
        }
        return name + DATA_MAP_SUFFIX;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class NameMapper
    extends BaseConfigurationNodeVisitor<String> {
        NameMapper() {
        }

        @Override
        public String visitDataChannelDescriptor(DataChannelDescriptor descriptor) {
            return DefaultConfigurationNameMapper.this.getDataChannelName(descriptor.getName());
        }

        @Override
        public String visitDataMap(DataMap dataMap) {
            return DefaultConfigurationNameMapper.this.getDataMapName(dataMap.getName());
        }
    }
}

