/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.parser.ASTDbPath;
import org.apache.cayenne.exp.parser.ASTObjPath;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.reflect.UnresolvablePathException;
import org.apache.cayenne.util.ConversionUtil;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;
import org.apache.commons.collections.ComparatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ordering
implements Comparator<Object>,
Serializable,
XMLSerializable {
    protected String sortSpecString;
    protected transient Expression sortSpec;
    protected SortOrder sortOrder;
    protected boolean pathExceptionSuppressed = false;
    protected boolean nullSortedFirst = true;

    public static void orderList(List<?> objects, List<Ordering> orderings) {
        Collections.sort(objects, ComparatorUtils.chainedComparator(orderings));
    }

    public Ordering() {
    }

    public Ordering(String sortPathSpec, SortOrder sortOrder) {
        this.setSortSpecString(sortPathSpec);
        this.setSortOrder(sortOrder);
    }

    public void setSortSpecString(String sortSpecString) {
        if (!Util.nullSafeEquals(this.sortSpecString, sortSpecString)) {
            this.sortSpecString = sortSpecString;
            this.sortSpec = null;
        }
    }

    public void setNullSortedFirst(boolean nullSortedFirst) {
        this.nullSortedFirst = nullSortedFirst;
    }

    public boolean isNullSortedFirst() {
        return this.nullSortedFirst;
    }

    public void setPathExceptionSupressed(boolean pathExceptionSuppressed) {
        this.pathExceptionSuppressed = pathExceptionSuppressed;
    }

    public boolean isPathExceptionSuppressed() {
        return this.pathExceptionSuppressed;
    }

    public String getSortSpecString() {
        return this.sortSpecString;
    }

    public void setSortOrder(SortOrder order) {
        this.sortOrder = order;
    }

    public boolean isAscending() {
        return this.sortOrder == null || this.sortOrder == SortOrder.ASCENDING || this.sortOrder == SortOrder.ASCENDING_INSENSITIVE;
    }

    public boolean isDescending() {
        return !this.isAscending();
    }

    public void setAscending() {
        if (this.sortOrder == null || this.sortOrder == SortOrder.DESCENDING) {
            this.setSortOrder(SortOrder.ASCENDING);
        } else if (this.sortOrder == SortOrder.DESCENDING_INSENSITIVE) {
            this.setSortOrder(SortOrder.ASCENDING_INSENSITIVE);
        }
    }

    public void setDescending() {
        if (this.sortOrder == null || this.sortOrder == SortOrder.ASCENDING) {
            this.setSortOrder(SortOrder.DESCENDING);
        } else if (this.sortOrder == SortOrder.ASCENDING_INSENSITIVE) {
            this.setSortOrder(SortOrder.DESCENDING_INSENSITIVE);
        }
    }

    public boolean isCaseInsensitive() {
        return !this.isCaseSensitive();
    }

    public boolean isCaseSensitive() {
        return this.sortOrder == null || this.sortOrder == SortOrder.ASCENDING || this.sortOrder == SortOrder.DESCENDING;
    }

    public void setCaseInsensitive() {
        if (this.sortOrder == null || this.sortOrder == SortOrder.ASCENDING) {
            this.setSortOrder(SortOrder.ASCENDING_INSENSITIVE);
        } else if (this.sortOrder == SortOrder.DESCENDING) {
            this.setSortOrder(SortOrder.DESCENDING_INSENSITIVE);
        }
    }

    public void setCaseSensitive() {
        if (this.sortOrder == null || this.sortOrder == SortOrder.ASCENDING_INSENSITIVE) {
            this.setSortOrder(SortOrder.ASCENDING);
        } else if (this.sortOrder == SortOrder.DESCENDING_INSENSITIVE) {
            this.setSortOrder(SortOrder.DESCENDING);
        }
    }

    public Expression getSortSpec() {
        if (this.sortSpecString == null) {
            return null;
        }
        if (this.sortSpec == null) {
            this.sortSpec = this.sortSpecString.startsWith("db:") ? new ASTDbPath(this.sortSpecString.substring("db:".length())) : (this.sortSpecString.startsWith("obj:") ? new ASTObjPath(this.sortSpecString.substring("obj:".length())) : new ASTObjPath(this.sortSpecString));
        }
        return this.sortSpec;
    }

    public void setSortSpec(Expression sortSpec) {
        this.sortSpec = sortSpec;
        this.sortSpecString = sortSpec != null ? sortSpec.toString() : null;
    }

    public void orderList(List<?> objects) {
        Collections.sort(objects, this);
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object value2;
        Object value1;
        block9: {
            Expression exp;
            block8: {
                exp = this.getSortSpec();
                value1 = null;
                value2 = null;
                try {
                    value1 = exp.evaluate(o1);
                }
                catch (ExpressionException e) {
                    if (this.pathExceptionSuppressed && e.getCause() instanceof UnresolvablePathException) break block8;
                    throw e;
                }
            }
            try {
                value2 = exp.evaluate(o2);
            }
            catch (ExpressionException e) {
                if (this.pathExceptionSuppressed && e.getCause() instanceof UnresolvablePathException) break block9;
                throw e;
            }
        }
        if (value1 == null && value2 == null) {
            return 0;
        }
        if (value1 == null) {
            return this.nullSortedFirst ? -1 : 1;
        }
        if (value2 == null) {
            return this.nullSortedFirst ? 1 : -1;
        }
        if (this.isCaseInsensitive()) {
            value1 = ConversionUtil.toUpperCase(value1);
            value2 = ConversionUtil.toUpperCase(value2);
        }
        int compareResult = ConversionUtil.toComparable(value1).compareTo(ConversionUtil.toComparable(value2));
        return this.isAscending() ? compareResult : -compareResult;
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<ordering");
        if (this.isDescending()) {
            encoder.print(" descending=\"true\"");
        }
        if (this.isCaseInsensitive()) {
            encoder.print(" ignore-case=\"true\"");
        }
        encoder.print(">");
        if (this.getSortSpec() != null) {
            this.getSortSpec().encodeAsXML(encoder);
        }
        encoder.println("</ordering>");
    }

    public String toString() {
        StringWriter buffer = new StringWriter();
        PrintWriter pw = new PrintWriter(buffer);
        XMLEncoder encoder = new XMLEncoder(pw);
        this.encodeAsXML(encoder);
        pw.close();
        buffer.flush();
        return buffer.toString();
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }
}

