/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.util.DefaultOperationObserver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResult
extends DefaultOperationObserver {
    protected Map queries = new LinkedHashMap();

    public void clear() {
        this.queries.clear();
    }

    public Iterator getQueries() {
        return this.queries.keySet().iterator();
    }

    public List getResults(Query query) {
        List list = (List)this.queries.get(query);
        return list != null ? list : Collections.EMPTY_LIST;
    }

    public int getFirstUpdateCount(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size > 0) {
            for (Object object : allResults) {
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
                if (!(object instanceof int[])) continue;
                int[] counts = (int[])object;
                return counts.length > 0 ? counts[0] : -1;
            }
        }
        return -1;
    }

    public int[] getFirstUpdateCounts(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size > 0) {
            for (Object object : allResults) {
                if (object instanceof Number) {
                    return new int[]{((Number)object).intValue()};
                }
                if (!(object instanceof int[])) continue;
                return (int[])object;
            }
        }
        return new int[0];
    }

    public List getFirstRows(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        for (Object obj : allResults) {
            if (!(obj instanceof List)) continue;
            return (List)obj;
        }
        return Collections.EMPTY_LIST;
    }

    public List<?> getRows(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList(size);
        for (Object obj : allResults) {
            if (!(obj instanceof List)) continue;
            list.add(obj);
        }
        return list;
    }

    public List getUpdates(Query query) {
        List allResults = this.getResults(query);
        int size = allResults.size();
        if (size == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList list = new ArrayList(size);
        for (Object object : allResults) {
            int[] ints;
            if (object instanceof Number) {
                list.add(object);
                continue;
            }
            if (!(object instanceof int[])) continue;
            for (int anInt : ints = (int[])object) {
                list.add(anInt);
            }
        }
        return list;
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        super.nextQueryException(query, ex);
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex), new Object[0]);
    }

    @Override
    public void nextGlobalException(Exception ex) {
        super.nextGlobalException(ex);
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(ex), new Object[0]);
    }

    @Override
    public boolean isIteratedResult() {
        return false;
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        ArrayList<int[]> list = (ArrayList<int[]>)this.queries.get(query);
        if (list == null) {
            list = new ArrayList<int[]>(5);
            this.queries.put(query, list);
        }
        list.add(resultCount);
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        super.nextCount(query, resultCount);
        ArrayList<Integer> list = (ArrayList<Integer>)this.queries.get(query);
        if (list == null) {
            list = new ArrayList<Integer>(5);
            this.queries.put(query, list);
        }
        list.add(resultCount);
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
        super.nextRows(query, dataRows);
        ArrayList list = (ArrayList)this.queries.get(query);
        if (list == null) {
            list = new ArrayList(5);
            this.queries.put(query, list);
        }
        list.add(dataRows);
    }

    @Override
    public void nextRows(Query q, ResultIterator it) {
        throw new CayenneRuntimeException("Iterated results are not supported by " + this.getClass().getName(), new Object[0]);
    }
}

