/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.DataRowPostProcessor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.RowReader;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.QueryMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseRowReader<T>
implements RowReader<T> {
    ExtendedType[] converters;
    String[] labels;
    int[] types;
    DataRowPostProcessor postProcessor;
    String entityName;

    BaseRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        ObjEntity rootObjEntity = queryMetadata.getObjEntity();
        if (rootObjEntity != null) {
            this.entityName = rootObjEntity.getName();
        }
        this.converters = descriptor.getConverters();
        ColumnDescriptor[] columns = descriptor.getColumns();
        int width = columns.length;
        this.labels = new String[width];
        this.types = new int[width];
        for (int i = 0; i < width; ++i) {
            this.labels[i] = columns[i].getDataRowKey();
            this.types[i] = columns[i].getJdbcType();
        }
    }

    @Override
    public abstract T readRow(ResultSet var1);

    @Override
    public void setPostProcessor(DataRowPostProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }
}

