/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.access.jdbc.BaseRowReader;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IdRowReader<T>
extends BaseRowReader<T> {
    protected int[] pkIndices;

    public IdRowReader(RowDescriptor descriptor, QueryMetadata queryMetadata) {
        super(descriptor, queryMetadata);
        DbEntity dbEntity = queryMetadata.getDbEntity();
        if (dbEntity == null) {
            throw new CayenneRuntimeException("Null root DbEntity, can't index PK", new Object[0]);
        }
        int len = dbEntity.getPrimaryKeys().size();
        if (len == 0) {
            throw new CayenneRuntimeException("Root DBEntity has no PK defined: " + dbEntity, new Object[0]);
        }
        int[] pk = new int[len];
        ColumnDescriptor[] columns = descriptor.getColumns();
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            DbAttribute a = (DbAttribute)dbEntity.getAttribute(columns[i].getName());
            if (a == null || !a.isPrimaryKey()) continue;
            pk[j++] = i;
        }
        this.pkIndices = pk;
    }

    @Override
    public T readRow(ResultSet resultSet) {
        try {
            if (this.pkIndices.length == 1) {
                return this.readSingleId(resultSet);
            }
            return this.readIdMap(resultSet);
        }
        catch (CayenneRuntimeException cex) {
            throw cex;
        }
        catch (Exception otherex) {
            throw new CayenneRuntimeException("Exception materializing id column.", Util.unwindException(otherex), new Object[0]);
        }
    }

    private T readSingleId(ResultSet resultSet) throws Exception {
        int index = this.pkIndices[0];
        Object val = this.converters[index].materializeObject(resultSet, index + 1, this.types[index]);
        return (T)val;
    }

    private T readIdMap(ResultSet resultSet) throws Exception {
        DataRow idRow = new DataRow(2);
        idRow.setEntityName(this.entityName);
        for (int index : this.pkIndices) {
            Object val = this.converters[index].materializeObject(resultSet, index + 1, this.types[index]);
            idRow.put(this.labels[index], val);
        }
        if (this.postProcessor != null) {
            this.postProcessor.postprocessRow(resultSet, idRow);
        }
        return (T)idRow;
    }
}

