/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.AddColumnToDb;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;
import org.apache.cayenne.merge.SetNotNullToDb;

public class SQLServerMergerFactory
extends MergerFactory {
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(entity));
                sqlBuffer.append(" ALTER COLUMN ");
                sqlBuffer.append(context.quotedName(columnNew));
                sqlBuffer.append(" ");
            }
        };
    }

    public MergerToken createAddColumnToDb(final DbEntity entity, final DbAttribute column) {
        return new AddColumnToDb(entity, column){

            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quotedFullyQualifiedName(entity));
                sqlBuffer.append(" ADD ");
                sqlBuffer.append(context.quotedName(column));
                sqlBuffer.append(" ");
            }
        };
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(adapter.getQuotingStrategy().quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" ALTER COLUMN ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }

    public MergerToken createSetNotNullToDb(DbEntity entity, final DbAttribute column) {
        return new SetNotNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuffer sqlBuffer = new StringBuffer();
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(adapter.getQuotingStrategy().quotedFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" ALTER COLUMN ");
                adapter.createTableAppendColumn(sqlBuffer, column);
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }
}

