/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.apache.cayenne.ConfigurationException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.Provider;
import org.apache.cayenne.di.spi.DIUtil;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.InjectionStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorInjectingProvider<T>
implements Provider<T> {
    private Constructor<? extends T> constructor;
    private DefaultInjector injector;
    private String[] bindingNames;

    ConstructorInjectingProvider(Class<? extends T> implementation, DefaultInjector injector) {
        this.initConstructor(implementation);
        if (this.constructor == null) {
            throw new ConfigurationException("Can't find approprate constructor for implementation class '%s'", implementation.getName());
        }
        this.constructor.setAccessible(true);
        this.injector = injector;
    }

    private void initConstructor(Class<? extends T> implementation) {
        Constructor<?>[] constructors = implementation.getDeclaredConstructors();
        Constructor<?> lastMatch = null;
        int lastSize = -1;
        for (Constructor<?> constructor : constructors) {
            int size = constructor.getParameterTypes().length;
            if (size <= lastSize) continue;
            if (size == 0) {
                lastSize = 0;
                lastMatch = constructor;
                continue;
            }
            boolean injectable = true;
            for (Annotation[] annotations : constructor.getParameterAnnotations()) {
                boolean parameterInjectable = false;
                for (Annotation annotation : annotations) {
                    if (!annotation.annotationType().equals(Inject.class)) continue;
                    parameterInjectable = true;
                    break;
                }
                if (parameterInjectable) continue;
                injectable = false;
                break;
            }
            if (!injectable) continue;
            lastSize = size;
            lastMatch = constructor;
        }
        if (lastMatch == null) {
            throw new ConfigurationException("No applicable constructor is found for constructor injection in class '%s'", implementation.getName());
        }
        this.constructor = lastMatch;
        Annotation[][] annotations = lastMatch.getParameterAnnotations();
        this.bindingNames = new String[annotations.length];
        block3: for (int i = 0; i < annotations.length; ++i) {
            Annotation[] parameterAnnotations = annotations[i];
            for (int j = 0; j < parameterAnnotations.length; ++j) {
                Annotation annotation = parameterAnnotations[j];
                if (!annotation.annotationType().equals(Inject.class)) continue;
                Inject inject = (Inject)annotation;
                this.bindingNames[i] = inject.value();
                continue block3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Class<?>[] constructorParameters = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        Object[] args = new Object[constructorParameters.length];
        InjectionStack stack = this.injector.getInjectionStack();
        for (int i = 0; i < constructorParameters.length; ++i) {
            Class<?> parameter = constructorParameters[i];
            if (Provider.class.equals(parameter)) {
                Class<?> objectClass = DIUtil.parameterClass(genericTypes[i]);
                if (objectClass == null) {
                    throw new ConfigurationException("Constructor provider parameter %s must be parameterized to be usable for injection", parameter.getName());
                }
                args[i] = this.injector.getProvider(Key.get(objectClass, this.bindingNames[i]));
                continue;
            }
            Key<?> key = Key.get(parameter, this.bindingNames[i]);
            stack.push(key);
            try {
                args[i] = this.injector.getInstance(key);
                continue;
            }
            finally {
                stack.pop();
            }
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error instantiating class '%s'", (Throwable)e, this.constructor.getDeclaringClass().getName());
        }
    }
}

