/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.reflect.valueholder;

import java.util.Map;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.reflect.Accessor;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.PropertyDescriptor;
import org.apache.cayenne.reflect.PropertyException;
import org.apache.cayenne.reflect.ToManyMapProperty;
import org.apache.cayenne.reflect.valueholder.ValueHolderToManyProperty;
import org.apache.cayenne.util.PersistentObjectMap;

class ValueHolderMapProperty
extends ValueHolderToManyProperty
implements ToManyMapProperty {
    private Accessor mapKeyAccessor;

    ValueHolderMapProperty(ClassDescriptor owner, ClassDescriptor targetDescriptor, Accessor accessor, String reverseName, Accessor mapKeyAccessor) {
        super(owner, targetDescriptor, accessor, reverseName);
        this.mapKeyAccessor = mapKeyAccessor;
    }

    public void addTarget(Object source, Object target, boolean setReverse) {
        if (target == null) {
            throw new NullPointerException("Attempt to add null object.");
        }
        Map collection = (Map)this.readProperty(source);
        collection.put(this.getMapKey(target), target);
        if (setReverse) {
            this.setReverse(source, null, target);
        }
    }

    public void addTargetDirectly(Object source, Object target) throws PropertyException {
        PersistentObjectMap collection = (PersistentObjectMap)this.readProperty(source);
        collection.putDirectly(this.getMapKey(target), target);
    }

    public void removeTarget(Object source, Object target, boolean setReverse) {
        Map collection = (Map)this.readProperty(source);
        collection.remove(this.getMapKey(target));
        if (target != null && setReverse) {
            this.setReverse(source, target, null);
        }
    }

    public void removeTargetDirectly(Object source, Object target) throws PropertyException {
        PersistentObjectMap collection = (PersistentObjectMap)this.readProperty(source);
        collection.removeDirectly(this.getMapKey(target));
    }

    protected ValueHolder createCollectionValueHolder(Object object) throws PropertyException {
        if (!(object instanceof Persistent)) {
            throw new PropertyException("ValueHolders for non-persistent objects are not supported.", (PropertyDescriptor)this, object, new Object[0]);
        }
        return new PersistentObjectMap((Persistent)object, this.getName(), this.mapKeyAccessor);
    }

    public Object getMapKey(Object target) throws PropertyException {
        return this.mapKeyAccessor.getValue(target);
    }
}

