/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.firebird;

import java.io.IOException;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.dba.oracle.OracleQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTExtract;
import org.apache.cayenne.exp.parser.ASTFunctionCall;

public class FirebirdQualifierTranslator
extends QualifierTranslator {
    private int substringArg = 0;

    public FirebirdQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void doAppendPart(Expression rootNode) {
        if (rootNode == null) {
            return;
        }
        rootNode = rootNode.transform(new OracleQualifierTranslator.INTrimmer());
        rootNode.traverse(this);
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                break;
            }
            case "LENGTH": {
                this.out.append("CHAR_LENGTH");
                break;
            }
            case "LOCATE": {
                this.out.append("POSITION");
                break;
            }
            case "SUBSTRING": {
                this.substringArg = 0;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArg(Object value, ASTFunctionCall functionExpression) throws IOException {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            if (value instanceof String) {
                this.out.append("CAST(");
            }
            super.appendFunctionArg(value, functionExpression);
            if (value instanceof String) {
                this.clearLastFunctionArgDivider(functionExpression);
                this.out.append(" AS VARCHAR(").append(((String)value).length()).append("))");
                this.appendFunctionArgDivider(functionExpression);
            }
        } else if ("SUBSTRING".equals(functionExpression.getFunctionName())) {
            this.out.append("CAST(");
            super.appendFunctionArg(value, functionExpression);
            this.clearLastFunctionArgDivider(functionExpression);
            --this.substringArg;
            this.out.append(" AS INTEGER)");
            this.appendFunctionArgDivider(functionExpression);
        } else {
            super.appendFunctionArg(value, functionExpression);
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                this.out.append(" || ");
                break;
            }
            case "SUBSTRING": {
                switch (this.substringArg++) {
                    case 0: {
                        this.out.append(" FROM ");
                        break;
                    }
                    case 1: {
                        this.out.append(" FOR ");
                    }
                }
                break;
            }
            default: {
                super.appendFunctionArgDivider(functionExpression);
            }
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "CONCAT": {
                this.out.delete(this.out.length() - 4, this.out.length());
                break;
            }
            case "SUBSTRING": {
                if (this.substringArg == 1) {
                    this.out.delete(this.out.length() - " FROM ".length(), this.out.length());
                    break;
                }
                if (this.substringArg != 2) break;
                this.out.delete(this.out.length() - " FOR ".length(), this.out.length());
                break;
            }
            default: {
                super.clearLastFunctionArgDivider(functionExpression);
            }
        }
        if (functionExpression instanceof ASTExtract) {
            this.out.append(")");
        }
    }

    @Override
    protected boolean parenthesisNeeded(Expression node, Expression parentNode) {
        if (node.getType() == 45 && node instanceof ASTExtract) {
            return false;
        }
        return super.parenthesisNeeded(node, parentNode);
    }

    @Override
    protected void appendExtractFunction(ASTExtract functionExpression) {
        this.out.append("EXTRACT(");
        switch (functionExpression.getPart()) {
            case DAY_OF_MONTH: {
                this.out.append("DAY");
                break;
            }
            case DAY_OF_WEEK: {
                this.out.append("WEEKDAY");
                break;
            }
            case DAY_OF_YEAR: {
                this.out.append("YEARDAY");
                break;
            }
            default: {
                this.out.append(functionExpression.getPartCamelCaseName());
            }
        }
        this.out.append(" FROM ");
    }
}

