/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.access.translator.ejbql.EJBQLConditionTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.parser.Node;
import org.apache.cayenne.map.ObjAttribute;

class OracleEJBQLConditionTranslator
extends EJBQLConditionTranslator {
    OracleEJBQLConditionTranslator(EJBQLTranslationContext context) {
        super(context);
    }

    @Override
    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        expression.visit(new EJBQLPathTranslator(this.context){

            @Override
            protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
                OracleEJBQLConditionTranslator.this.addMultiColumnOperand(operand);
            }

            @Override
            protected void processTerminatingAttribute(ObjAttribute attribute) {
                if (attribute.getDbAttribute().getType() == 1) {
                    OracleEJBQLConditionTranslator.this.context.append(' ').append("RTRIM").append("(");
                    super.processTerminatingAttribute(attribute);
                    OracleEJBQLConditionTranslator.this.context.append(')');
                } else {
                    super.processTerminatingAttribute(attribute);
                }
            }
        });
        return false;
    }

    @Override
    public boolean visitLocate(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex < 0) {
            this.swapNodeChildren(expression, 0, 1);
            this.context.append(" INSTR(");
        } else if (finishedChildIndex + 1 == expression.getChildrenCount()) {
            this.context.append(")");
            this.swapNodeChildren(expression, 0, 1);
        } else {
            this.context.append(',');
        }
        return true;
    }

    private void swapNodeChildren(EJBQLExpression expression, int i, int j) {
        if (!(expression instanceof Node)) {
            return;
        }
        Node node = (Node)expression;
        Node tmp = node.jjtGetChild(i);
        node.jjtAddChild(node.jjtGetChild(j), i);
        node.jjtAddChild(tmp, j);
    }
}

