/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.access.types.ValueObjectType;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.di.Inject;

public class DefaultValueObjectTypeRegistry
implements ValueObjectTypeRegistry {
    final Map<String, ValueObjectType<?, ?>> typeCache = new ConcurrentHashMap();
    private static final ValueObjectType<?, ?> NULL_DUMMY = new ValueObjectType(){

        public Class<?> getTargetType() {
            return null;
        }

        public Class<?> getValueType() {
            return null;
        }

        public Object toJavaObject(Object value) {
            return null;
        }

        public Object fromJavaObject(Object object) {
            return null;
        }

        public String toCacheKey(Object object) {
            return null;
        }
    };

    public DefaultValueObjectTypeRegistry(@Inject List<ValueObjectType<?, ?>> valueObjectTypeList) {
        this.buildTypeCache(valueObjectTypeList);
    }

    private void buildTypeCache(List<ValueObjectType<?, ?>> valueObjectTypeList) {
        for (ValueObjectType<?, ?> valueObjectType : valueObjectTypeList) {
            this.typeCache.put(valueObjectType.getValueType().getName(), valueObjectType);
        }
    }

    @Override
    public <T> ValueObjectType<T, ?> getValueType(Class<? extends T> valueClass) {
        ValueObjectType<?, ?> type = this.typeCache.get(valueClass.getName());
        if (type == null) {
            type = this.findBySuperclasses(valueClass);
        } else if (type == NULL_DUMMY) {
            return null;
        }
        return type;
    }

    protected ValueObjectType<?, ?> findBySuperclasses(Class<?> baseClass) {
        ValueObjectType<?, ?> type = null;
        for (Class<?> searchClass = baseClass.getSuperclass(); searchClass != null && !searchClass.equals(Object.class); searchClass = searchClass.getSuperclass()) {
            type = this.typeCache.get(searchClass.getName());
            if (type == null) continue;
            this.typeCache.put(baseClass.getName(), type);
            break;
        }
        if (type == null) {
            this.typeCache.put(baseClass.getName(), NULL_DUMMY);
        }
        return type;
    }
}

