/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.access.loader.DbLoaderConfiguration;
import org.apache.cayenne.access.loader.DefaultDbLoaderDelegate;
import org.apache.cayenne.access.loader.ManyToManyCandidateEntity;
import org.apache.cayenne.access.loader.filters.DbPath;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.Filter;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.access.loader.filters.FiltersConfig;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DbRelationshipDetected;
import org.apache.cayenne.map.DetectedDbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.Procedure;
import org.apache.cayenne.map.ProcedureParameter;
import org.apache.cayenne.map.naming.DefaultUniqueNameGenerator;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.LegacyNameGenerator;
import org.apache.cayenne.map.naming.NameCheckers;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.apache.cayenne.util.EntityMergeSupport;
import org.apache.cayenne.util.EqualsBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbLoader {
    private static final Log LOGGER = LogFactory.getLog(DbLoader.class);
    public static final String WILDCARD = "%";
    public static final String WILDCARD_PATTERN = ".*";
    private final Connection connection;
    private final DbAdapter adapter;
    private final DbLoaderDelegate delegate;
    private boolean creatingMeaningfulPK;
    private DatabaseMetaData metaData;
    private ObjectNameGenerator nameGenerator;

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate) {
        this(connection, adapter, delegate, new LegacyNameGenerator());
    }

    public DbLoader(Connection connection, DbAdapter adapter, DbLoaderDelegate delegate, ObjectNameGenerator strategy) {
        this.adapter = adapter;
        this.connection = connection;
        this.delegate = delegate == null ? new DefaultDbLoaderDelegate() : delegate;
        this.setNameGenerator(strategy);
    }

    private DatabaseMetaData getMetaData() throws SQLException {
        if (this.metaData == null) {
            this.metaData = this.connection.getMetaData();
        }
        return this.metaData;
    }

    public void setCreatingMeaningfulPK(boolean creatingMeaningfulPK) {
        this.creatingMeaningfulPK = creatingMeaningfulPK;
    }

    public boolean isCreatingMeaningfulPK() {
        return this.creatingMeaningfulPK;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public List<String> getCatalogs() throws SQLException {
        return DbLoader.getStrings(this.getMetaData().getCatalogs());
    }

    public List<String> getSchemas() throws SQLException {
        return DbLoader.getStrings(this.getMetaData().getSchemas());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getStrings(ResultSet rs) throws SQLException {
        ArrayList<String> strings = new ArrayList<String>();
        try {
            while (rs.next()) {
                strings.add(rs.getString(1));
            }
        }
        finally {
            rs.close();
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTableTypes() throws SQLException {
        ArrayList<String> types = new ArrayList<String>();
        ResultSet rs = this.getMetaData().getTableTypes();
        try {
            while (rs.next()) {
                types.add(rs.getString("TABLE_TYPE").trim());
            }
        }
        finally {
            rs.close();
        }
        return types;
    }

    public Map<DbPath, Map<String, DbEntity>> getTables(DbLoaderConfiguration config, String[] types) throws SQLException {
        if (types == null || types.length == 0) {
            types = this.getDefaultTableTypes();
        }
        HashMap<DbPath, Map<String, DbEntity>> tables = new HashMap<DbPath, Map<String, DbEntity>>();
        FiltersConfig filters = config.getFiltersConfig();
        for (DbPath path : filters.pathsForQueries()) {
            tables.put(path, this.getDbEntities(filters, path, types));
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, DbEntity> getDbEntities(FiltersConfig filters, DbPath dbPath, String[] types) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Read tables: catalog=" + dbPath.catalog + ", schema=" + dbPath.schema + ", types=" + Arrays.toString(types)));
        }
        ResultSet rs = this.getMetaData().getTables(dbPath.catalog, dbPath.schema, WILDCARD, types);
        HashMap<String, DbEntity> tables = new HashMap<String, DbEntity>();
        try {
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                if (name == null) continue;
                DetectedDbEntity table = new DetectedDbEntity(name);
                String catalog = rs.getString("TABLE_CAT");
                table.setCatalog(catalog);
                String schema = rs.getString("TABLE_SCHEM");
                table.setSchema(schema);
                if (!filters.filter(new DbPath(catalog, schema)).tableFilter().isInclude(table)) continue;
                tables.put(name, table);
            }
        }
        finally {
            rs.close();
        }
        return tables;
    }

    public List<DbEntity> loadDbEntities(DataMap map, DbLoaderConfiguration config, Map<DbPath, Map<String, DbEntity>> tables) throws SQLException {
        ArrayList<DbEntity> dbEntityList = new ArrayList<DbEntity>();
        for (Map.Entry<DbPath, Map<String, DbEntity>> tablesMap : tables.entrySet()) {
            for (DbEntity dbEntity : tablesMap.getValue().values()) {
                DbEntity oldEnt = map.getDbEntity(dbEntity.getName());
                if (oldEnt != null) {
                    Collection<ObjEntity> oldObjEnt = map.getMappedEntities(oldEnt);
                    if (!oldObjEnt.isEmpty()) {
                        for (ObjEntity objEntity : oldObjEnt) {
                            LOGGER.debug((Object)("Delete ObjEntity: " + objEntity.getName()));
                            map.removeObjEntity(objEntity.getName(), true);
                            this.delegate.objEntityRemoved(objEntity);
                        }
                    }
                    LOGGER.debug((Object)("Overwrite DbEntity: " + oldEnt.getName()));
                    map.removeDbEntity(oldEnt.getName(), true);
                    this.delegate.dbEntityRemoved(oldEnt);
                }
                map.addDbEntity(dbEntity);
                this.delegate.dbEntityAdded(dbEntity);
                if (map.getDbEntity(dbEntity.getName()) != dbEntity) continue;
                dbEntityList.add(dbEntity);
            }
            this.loadDbAttributes(config.getFiltersConfig(), tablesMap.getKey(), tablesMap.getValue());
            if (config.isSkipPrimaryKeyLoading()) continue;
            this.getPrimaryKeyForTable(tablesMap.getValue());
        }
        return dbEntityList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPrimaryKeyForTable(Map<String, DbEntity> tables) throws SQLException {
        for (DbEntity dbEntity : tables.values()) {
            ResultSet rs = this.getMetaData().getPrimaryKeys(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName());
            try {
                while (rs.next()) {
                    String pkName;
                    String columnName = rs.getString("COLUMN_NAME");
                    DbAttribute attribute = dbEntity.getAttribute(columnName);
                    if (attribute != null) {
                        attribute.setPrimaryKey(true);
                    } else {
                        LOGGER.warn((Object)("Can't locate attribute for primary key: " + columnName));
                    }
                    if ((pkName = rs.getString("PK_NAME")) == null || !(dbEntity instanceof DetectedDbEntity)) continue;
                    ((DetectedDbEntity)dbEntity).setPrimaryKeyName(pkName);
                }
            }
            finally {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDbAttributes(FiltersConfig filters, DbPath path, Map<String, DbEntity> entities) throws SQLException {
        ResultSet rs = this.getMetaData().getColumns(path.catalog, path.schema, WILDCARD, WILDCARD);
        try {
            HashSet<String> columns = new HashSet<String>();
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                DbEntity dbEntity = entities.get(tableName);
                if (dbEntity == null) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Skip column for '" + tableName + "." + rs.getString("COLUMN_NAME") + "."));
                    continue;
                }
                DbAttribute attr = this.loadDbAttribute(columns, rs);
                attr.setEntity(dbEntity);
                Filter<DbAttribute> filter = filters.filter(new DbPath(dbEntity.getCatalog(), dbEntity.getSchema(), dbEntity.getName())).columnFilter();
                if (!filter.isInclude(attr)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Skip column for '" + attr.getEntity().getName() + "." + attr.getName() + "' (Path: " + path + "; Filter: " + filter + ")"));
                    continue;
                }
                if (dbEntity.getAttribute(attr.getName()) != null) {
                    dbEntity.removeAttribute(attr.getName());
                }
                dbEntity.addAttribute(attr);
            }
        }
        finally {
            rs.close();
        }
    }

    private DbAttribute loadDbAttribute(Set<String> columns, ResultSet rs) throws SQLException {
        String autoIncrement;
        if (columns.isEmpty()) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                columns.add(rsMetaData.getColumnLabel(i));
            }
        }
        int columnType = rs.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal(columnType)) {
            decimalDigits = rs.getInt("DECIMAL_DIGITS");
            if (rs.wasNull()) {
                decimalDigits = -1;
            }
        }
        DbAttribute attr = this.adapter.buildAttribute(rs.getString("COLUMN_NAME"), rs.getString("TYPE_NAME"), columnType, rs.getInt("COLUMN_SIZE"), decimalDigits, rs.getBoolean("NULLABLE"));
        if (columns.contains("IS_AUTOINCREMENT") && "YES".equals(autoIncrement = rs.getString("IS_AUTOINCREMENT"))) {
            attr.setGenerated(true);
        }
        return attr;
    }

    public Collection<ObjEntity> loadObjEntities(DataMap map, DbLoaderConfiguration config, Collection<DbEntity> entities) {
        Collection<ObjEntity> loadedEntities = DbLoader.loadObjEntities(map, config, entities, this.nameGenerator);
        this.createEntityMerger(map).synchronizeWithDbEntities(loadedEntities);
        return loadedEntities;
    }

    public static Collection<ObjEntity> loadObjEntities(DataMap map, DbLoaderConfiguration config, Collection<DbEntity> entities, ObjectNameGenerator nameGenerator) {
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ObjEntity> loadedEntities = new ArrayList<ObjEntity>(entities.size());
        for (DbEntity dbEntity : entities) {
            Collection<ObjEntity> existing = map.getMappedEntities(dbEntity);
            if (!existing.isEmpty()) {
                loadedEntities.addAll(existing);
                continue;
            }
            String objEntityName = DefaultUniqueNameGenerator.generate(NameCheckers.objEntity, map, nameGenerator.createObjEntityName(dbEntity));
            ObjEntity objEntity = new ObjEntity(objEntityName);
            objEntity.setDbEntity(dbEntity);
            objEntity.setClassName(config.getGenericClassName() != null ? config.getGenericClassName() : map.getNameWithDefaultPackage(objEntity.getName()));
            map.addObjEntity(objEntity);
            loadedEntities.add(objEntity);
        }
        return loadedEntities;
    }

    protected EntityMergeSupport createEntityMerger(DataMap map) {
        return new EntityMergeSupport(map, this.nameGenerator, !this.creatingMeaningfulPK);
    }

    protected void loadDbRelationships(DbLoaderConfiguration config, Map<DbPath, Map<String, DbEntity>> tables) throws SQLException {
        if (config.isSkipRelationshipsLoading()) {
            return;
        }
        for (Map.Entry<DbPath, Map<String, DbEntity>> pathEntry : tables.entrySet()) {
            Map<String, Set<ExportedKey>> keys = this.loadExportedKeys(config, pathEntry.getKey(), pathEntry.getValue());
            for (Map.Entry<String, Set<ExportedKey>> entry : keys.entrySet()) {
                Set<ExportedKey> exportedKeys;
                ExportedKey key;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Process keys for: " + entry.getKey()));
                }
                if ((key = (exportedKeys = entry.getValue()).iterator().next()) == null) {
                    throw new IllegalStateException();
                }
                DbEntity pkEntity = pathEntry.getValue().get(key.getPKTableName());
                if (pkEntity == null) {
                    this.skipRelationLog(key, key.getPKTableName());
                    continue;
                }
                DbEntity fkEntity = pathEntry.getValue().get(key.getFKTableName());
                if (fkEntity == null) {
                    this.skipRelationLog(key, key.getFKTableName());
                    continue;
                }
                if (!new EqualsBuilder().append(pkEntity.getCatalog(), key.pkCatalog).append(pkEntity.getSchema(), key.pkSchema).append(fkEntity.getCatalog(), key.fkCatalog).append(fkEntity.getSchema(), key.fkSchema).isEquals()) {
                    LOGGER.info((Object)("Skip relation: '" + key + "' because it related to objects from other catalog/schema"));
                    LOGGER.info((Object)("     relation primary key: '" + key.pkCatalog + "." + key.pkSchema + "'"));
                    LOGGER.info((Object)("       primary key entity: '" + pkEntity.getCatalog() + "." + pkEntity.getSchema() + "'"));
                    LOGGER.info((Object)("     relation foreign key: '" + key.fkCatalog + "." + key.fkSchema + "'"));
                    LOGGER.info((Object)("       foreign key entity: '" + fkEntity.getCatalog() + "." + fkEntity.getSchema() + "'"));
                    continue;
                }
                DbRelationship forwardRelationship = new DbRelationship(this.generateName(pkEntity, key, true));
                forwardRelationship.setSourceEntity(pkEntity);
                forwardRelationship.setTargetEntityName(fkEntity);
                DbRelationshipDetected reverseRelationship = new DbRelationshipDetected(this.generateName(fkEntity, key, false));
                reverseRelationship.setFkName(key.getFKName());
                reverseRelationship.setSourceEntity(fkEntity);
                reverseRelationship.setTargetEntityName(pkEntity);
                reverseRelationship.setToMany(false);
                this.createAndAppendJoins(exportedKeys, pkEntity, fkEntity, forwardRelationship, reverseRelationship);
                boolean toDependentPK = this.isToDependentPK(forwardRelationship);
                forwardRelationship.setToDependentPK(toDependentPK);
                boolean isOneToOne = toDependentPK && fkEntity.getPrimaryKeys().size() == forwardRelationship.getJoins().size();
                forwardRelationship.setToMany(!isOneToOne);
                forwardRelationship.setName(this.generateName(pkEntity, key, !isOneToOne));
                if (this.delegate.dbRelationshipLoaded(fkEntity, reverseRelationship)) {
                    fkEntity.addRelationship(reverseRelationship);
                }
                if (!this.delegate.dbRelationshipLoaded(pkEntity, forwardRelationship)) continue;
                pkEntity.addRelationship(forwardRelationship);
            }
        }
    }

    private boolean isToDependentPK(DbRelationship forwardRelationship) {
        for (DbJoin dbJoin : forwardRelationship.getJoins()) {
            if (dbJoin.getTarget().isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    private void createAndAppendJoins(Set<ExportedKey> exportedKeys, DbEntity pkEntity, DbEntity fkEntity, DbRelationship forwardRelationship, DbRelationshipDetected reverseRelationship) {
        for (ExportedKey exportedKey : exportedKeys) {
            String pkName = exportedKey.getPKColumnName();
            String fkName = exportedKey.getFKColumnName();
            DbAttribute pkAtt = pkEntity.getAttribute(pkName);
            if (pkAtt == null) {
                LOGGER.info((Object)("no attribute for declared primary key: " + pkName));
                continue;
            }
            DbAttribute fkAtt = fkEntity.getAttribute(fkName);
            if (fkAtt == null) {
                LOGGER.info((Object)("no attribute for declared foreign key: " + fkName));
                continue;
            }
            forwardRelationship.addJoin(new DbJoin(forwardRelationship, pkName, fkName));
            reverseRelationship.addJoin(new DbJoin(reverseRelationship, fkName, pkName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<ExportedKey>> loadExportedKeys(DbLoaderConfiguration config, DbPath dbPath, Map<String, DbEntity> tables) throws SQLException {
        HashMap<String, Set<ExportedKey>> keys = new HashMap<String, Set<ExportedKey>>();
        for (DbEntity dbEntity : tables.values()) {
            ResultSet rs;
            if (!this.delegate.dbRelationship(dbEntity)) continue;
            try {
                rs = this.getMetaData().getExportedKeys(dbPath.catalog, dbPath.schema, dbEntity.getName());
            }
            catch (SQLException cay182Ex) {
                LOGGER.info((Object)("Error getting relationships for '" + dbPath + "', ignoring. " + cay182Ex.getMessage()), (Throwable)cay182Ex);
                return new HashMap<String, Set<ExportedKey>>();
            }
            try {
                while (rs.next()) {
                    ExportedKey key = ExportedKey.extractData(rs);
                    DbEntity fkEntity = tables.get(key.getFKTableName());
                    if (fkEntity == null) {
                        this.skipRelationLog(key, key.getFKTableName());
                        continue;
                    }
                    DbPath path = new DbPath(fkEntity.getCatalog(), fkEntity.getSchema(), fkEntity.getName());
                    if (!config.getFiltersConfig().filter(path).tableFilter().isInclude(fkEntity)) continue;
                    TreeSet<ExportedKey> exportedKeys = (TreeSet<ExportedKey>)keys.get(key.getStrKey());
                    if (exportedKeys == null) {
                        exportedKeys = new TreeSet<ExportedKey>();
                        keys.put(key.getStrKey(), exportedKeys);
                    }
                    exportedKeys.add(key);
                }
            }
            finally {
                rs.close();
            }
        }
        return keys;
    }

    private void skipRelationLog(ExportedKey key, String tableName) {
        LOGGER.info((Object)("Skip relation: '" + key + "' because table '" + tableName + "' not found"));
    }

    private String generateName(DbEntity entity, ExportedKey key, boolean toMany) {
        String forwardPreferredName = this.nameGenerator.createDbRelationshipName(key, toMany);
        return DefaultUniqueNameGenerator.generate(NameCheckers.dbRelationship, entity, forwardPreferredName);
    }

    protected void postProcessMasterDbRelationship(DbRelationship relationship, ExportedKey key) {
    }

    public static void flattenManyToManyRelationships(DataMap map, Collection<ObjEntity> loadedObjEntities, ObjectNameGenerator objectNameGenerator) {
        if (loadedObjEntities.isEmpty()) {
            return;
        }
        LinkedList<ObjEntity> entitiesForDelete = new LinkedList<ObjEntity>();
        for (ObjEntity curEntity : loadedObjEntities) {
            ManyToManyCandidateEntity entity = ManyToManyCandidateEntity.build(curEntity);
            if (entity == null) continue;
            entity.optimizeRelationships(objectNameGenerator);
            entitiesForDelete.add(curEntity);
        }
        for (ObjEntity curDeleteEntity : entitiesForDelete) {
            map.removeObjEntity(curDeleteEntity.getName(), true);
        }
        loadedObjEntities.removeAll(entitiesForDelete);
    }

    private void fireObjEntitiesAddedEvents(Collection<ObjEntity> loadedObjEntities) {
        for (ObjEntity curEntity : loadedObjEntities) {
            if (this.delegate == null) continue;
            this.delegate.objEntityAdded(curEntity);
        }
    }

    public String[] getDefaultTableTypes() {
        String tableType;
        ArrayList<String> list = new ArrayList<String>(2);
        String viewType = this.adapter.tableTypeForView();
        if (viewType != null) {
            list.add(viewType);
        }
        if ((tableType = this.adapter.tableTypeForTable()) != null) {
            list.add(tableType);
        }
        return list.toArray(new String[list.size()]);
    }

    @Deprecated
    public DataMap loadDataMapFromDB(String schemaPattern, String tablePattern, DataMap dataMap) throws SQLException {
        DbLoaderConfiguration configuration = new DbLoaderConfiguration();
        configuration.setFiltersConfig(new FiltersConfig(new EntityFilters(new DbPath(null, schemaPattern), FilterFactory.include(tablePattern), FilterFactory.TRUE, FilterFactory.NULL)));
        this.load(dataMap, configuration);
        return dataMap;
    }

    @Deprecated
    public DataMap loadDataMapFromDB(String schemaPattern, String tablePattern, String[] tableTypes, DataMap dataMap) throws SQLException {
        dataMap.clear();
        DbLoaderConfiguration config = new DbLoaderConfiguration();
        config.setFiltersConfig(new FiltersConfig(new EntityFilters(new DbPath(null, schemaPattern), this.transformPatternToFilter(tablePattern), FilterFactory.TRUE, FilterFactory.NULL)));
        config.setTableTypes(tableTypes);
        this.load(dataMap, config);
        return dataMap;
    }

    private Filter<String> transformPatternToFilter(String tablePattern) {
        Filter<String> table = tablePattern == null ? FilterFactory.NULL : FilterFactory.include(tablePattern.replaceAll(WILDCARD, WILDCARD_PATTERN));
        return table;
    }

    public void load(DataMap dataMap, DbLoaderConfiguration config) throws SQLException {
        LOGGER.info((Object)"Schema loading...");
        Map<DbPath, Map<String, DbEntity>> tables = this.getTables(config, config.getTableTypes());
        List<DbEntity> entities = this.loadDbEntities(dataMap, config, tables);
        if (entities != null) {
            this.loadDbRelationships(config, tables);
            this.prepareObjLayer(dataMap, config, entities);
        }
    }

    public void prepareObjLayer(DataMap dataMap, DbLoaderConfiguration config, Collection<DbEntity> entities) {
        Collection<ObjEntity> loadedObjEntities = this.loadObjEntities(dataMap, config, entities);
        DbLoader.flattenManyToManyRelationships(dataMap, loadedObjEntities, this.getNameGenerator());
        this.fireObjEntitiesAddedEvents(loadedObjEntities);
    }

    public DataMap load(DbLoaderConfiguration config) throws SQLException {
        DataMap dataMap = new DataMap();
        this.load(dataMap, config);
        this.loadProcedures(dataMap, config);
        return dataMap;
    }

    @Deprecated
    public void loadProceduresFromDB(String schemaPattern, String namePattern, DataMap dataMap) throws SQLException {
        DbLoaderConfiguration configuration = new DbLoaderConfiguration();
        configuration.setFiltersConfig(new FiltersConfig(new EntityFilters(new DbPath(null, schemaPattern), FilterFactory.NULL, FilterFactory.NULL, FilterFactory.include(namePattern))));
        this.loadProcedures(dataMap, configuration);
    }

    public Map<String, Procedure> loadProcedures(DataMap dataMap, DbLoaderConfiguration config) throws SQLException {
        Map<String, Procedure> procedures = this.loadProcedures(config);
        if (procedures.isEmpty()) {
            return procedures;
        }
        this.loadProceduresColumns(config, procedures);
        for (Procedure procedure : procedures.values()) {
            dataMap.addProcedure(procedure);
        }
        return procedures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProceduresColumns(DbLoaderConfiguration config, Map<String, Procedure> procedures) throws SQLException {
        for (DbPath dbPath : config.getFiltersConfig().pathsForQueries()) {
            ResultSet columnsRS = this.getMetaData().getProcedureColumns(dbPath.catalog, dbPath.schema, null, null);
            try {
                while (columnsRS.next()) {
                    ProcedureParameter column;
                    String schema = columnsRS.getString("PROCEDURE_SCHEM");
                    String name = columnsRS.getString("PROCEDURE_NAME");
                    String key = (schema == null ? "" : schema + '.') + name;
                    Procedure procedure = procedures.get(key);
                    if (procedure == null || (column = this.loadProcedureParams(columnsRS, key, procedure)) == null) continue;
                    procedure.addCallParameter(column);
                }
            }
            finally {
                columnsRS.close();
            }
        }
    }

    private ProcedureParameter loadProcedureParams(ResultSet columnsRS, String key, Procedure procedure) throws SQLException {
        String columnName = columnsRS.getString("COLUMN_NAME");
        short type = columnsRS.getShort("COLUMN_TYPE");
        if (type == 3) {
            LOGGER.debug((Object)("skipping ResultSet column: " + key + "." + columnName));
        }
        if (columnName == null) {
            if (type == 5) {
                LOGGER.debug((Object)("null column name, assuming result column: " + key));
                columnName = "_return_value";
                procedure.setReturningValue(true);
            } else {
                LOGGER.info((Object)("invalid null column name, skipping column : " + key));
                return null;
            }
        }
        int columnType = columnsRS.getInt("DATA_TYPE");
        int decimalDigits = -1;
        if (TypesMapping.isDecimal(columnType)) {
            decimalDigits = columnsRS.getShort("SCALE");
            if (columnsRS.wasNull()) {
                decimalDigits = -1;
            }
        }
        ProcedureParameter column = new ProcedureParameter(columnName);
        int direction = DbLoader.getDirection(type);
        if (direction != -1) {
            column.setDirection(direction);
        }
        column.setType(columnType);
        column.setMaxLength(columnsRS.getInt("LENGTH"));
        column.setPrecision(decimalDigits);
        column.setProcedure(procedure);
        return column;
    }

    private static int getDirection(short type) {
        switch (type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 2;
            }
        }
        return -1;
    }

    private Map<String, Procedure> loadProcedures(DbLoaderConfiguration config) throws SQLException {
        HashMap<String, Procedure> procedures = new HashMap<String, Procedure>();
        FiltersConfig filters = config.getFiltersConfig();
        for (DbPath dbPath : filters.pathsForQueries()) {
            if (filters.filter(dbPath).procedureFilter().equals(FilterFactory.NULL)) continue;
            procedures.putAll(this.loadProcedures(filters, dbPath));
        }
        return procedures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Procedure> loadProcedures(FiltersConfig filters, DbPath dbPath) throws SQLException {
        HashMap<String, Procedure> procedures = new HashMap<String, Procedure>();
        ResultSet rs = this.getMetaData().getProcedures(dbPath.catalog, dbPath.schema, WILDCARD);
        try {
            while (rs.next()) {
                String name = rs.getString("PROCEDURE_NAME");
                Procedure procedure = new Procedure(name);
                procedure.setCatalog(rs.getString("PROCEDURE_CAT"));
                procedure.setSchema(rs.getString("PROCEDURE_SCHEM"));
                if (filters.filter(new DbPath(procedure.getCatalog(), procedure.getSchema())).procedureFilter().isInclude(procedure)) {
                    LOGGER.info((Object)("skipping Cayenne PK procedure: " + name));
                    continue;
                }
                switch (rs.getShort("PROCEDURE_TYPE")) {
                    case 0: 
                    case 1: {
                        procedure.setReturningValue(false);
                        break;
                    }
                    case 2: {
                        procedure.setReturningValue(true);
                    }
                }
                procedures.put(procedure.getFullyQualifiedName(), procedure);
            }
        }
        finally {
            rs.close();
        }
        return procedures;
    }

    public void setNameGenerator(ObjectNameGenerator strategy) {
        if (strategy == null) {
            LOGGER.warn((Object)"Attempt to set null into NameGenerator. LegacyNameGenerator will be used.");
            this.nameGenerator = new LegacyNameGenerator();
        } else {
            this.nameGenerator = strategy;
        }
    }

    public ObjectNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }
}

