/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.batch;

import java.util.List;
import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslator;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.InsertBatchQuery;

public class InsertBatchTranslator
extends DefaultBatchTranslator {
    public InsertBatchTranslator(InsertBatchQuery query, DbAdapter adapter) {
        super(query, adapter, null);
    }

    @Override
    protected String createSql() {
        List<DbAttribute> dbAttributes = this.query.getDbAttributes();
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buffer = new StringBuilder("INSERT INTO ");
        buffer.append(strategy.quotedFullyQualifiedName(this.query.getDbEntity()));
        buffer.append(" (");
        int columnCount = 0;
        for (DbAttribute attribute : dbAttributes) {
            if (!this.includeInBatch(attribute)) continue;
            if (columnCount > 0) {
                buffer.append(", ");
            }
            buffer.append(strategy.quotedName(attribute));
            ++columnCount;
        }
        buffer.append(") VALUES (");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('?');
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    protected BatchParameterBinding[] createBindings() {
        List<DbAttribute> attributes = this.query.getDbAttributes();
        int len = attributes.size();
        BatchParameterBinding[] bindings = new BatchParameterBinding[len];
        for (int i = 0; i < len; ++i) {
            DbAttribute a = attributes.get(i);
            bindings[i] = new BatchParameterBinding(a);
            if (this.includeInBatch(a)) {
                bindings[i].include(1, null);
                continue;
            }
            bindings[i].exclude();
        }
        return bindings;
    }

    @Override
    protected BatchParameterBinding[] doUpdateBindings(BatchQueryRow row) {
        int len = this.bindings.length;
        int j = 1;
        for (int i = 0; i < len; ++i) {
            BatchParameterBinding b = this.bindings[i];
            if (b.isExcluded()) continue;
            b.include(j++, row.getValue(i));
        }
        return this.bindings;
    }

    protected boolean includeInBatch(DbAttribute attribute) {
        return !attribute.isGenerated() || attribute.isPrimaryKey() && !this.adapter.supportsGeneratedKeys();
    }
}

