/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.QueryAssemblerHelper;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SelectQuery;

public class OrderingTranslator
extends QueryAssemblerHelper {
    protected List<String> orderByColumnList = new ArrayList<String>();

    public OrderingTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppendPart() throws IOException {
        Query q = this.queryAssembler.getQuery();
        if (q == null || !(q instanceof SelectQuery)) {
            return;
        }
        Iterator<Ordering> it = ((SelectQuery)q).getOrderings().iterator();
        Appendable mainBuffer = this.out;
        try {
            while (it.hasNext()) {
                Expression exp;
                Ordering ord = it.next();
                this.out = new StringBuilder();
                if (ord.isCaseInsensitive()) {
                    this.out.append("UPPER(");
                }
                if ((exp = ord.getSortSpec()).getType() == 26) {
                    this.appendObjPath(exp);
                } else if (exp.getType() == 27) {
                    this.appendDbPath(exp);
                } else {
                    throw new CayenneRuntimeException("Unsupported ordering expression: " + exp, new Object[0]);
                }
                if (ord.isCaseInsensitive()) {
                    this.out.append(")");
                }
                String columnSQL = this.out.toString();
                mainBuffer.append(columnSQL);
                this.orderByColumnList.add(columnSQL);
                if (!ord.isAscending()) {
                    mainBuffer.append(" DESC");
                }
                if (!it.hasNext()) continue;
                mainBuffer.append(", ");
            }
        }
        finally {
            this.out = mainBuffer;
        }
    }

    public List<String> getOrderByColumnList() {
        return this.orderByColumnList;
    }
}

