/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.io.IOException;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.map.DbAttribute;

public class TrimmingQualifierTranslator
extends QualifierTranslator {
    protected String trimFunction;

    public TrimmingQualifierTranslator(QueryAssembler queryAssembler, String trimFunction) {
        super(queryAssembler);
        this.trimFunction = trimFunction;
    }

    @Override
    protected void processColumn(DbAttribute dbAttr) throws IOException {
        if (dbAttr.getType() == 1) {
            this.out.append(this.trimFunction).append("(");
            super.processColumn(dbAttr);
            this.out.append(')');
        } else {
            super.processColumn(dbAttr);
        }
    }

    @Override
    protected void processColumnWithQuoteSqlIdentifiers(DbAttribute dbAttr, Expression pathExp) throws IOException {
        if (dbAttr.getType() == 1) {
            this.out.append(this.trimFunction).append("(");
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
            this.out.append(')');
        } else {
            super.processColumnWithQuoteSqlIdentifiers(dbAttr, pathExp);
        }
    }

    public String getTrimFunction() {
        return this.trimFunction;
    }

    public void setTrimFunction(String trimFunction) {
        this.trimFunction = trimFunction;
    }
}

