/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood.graph;

import java.util.NoSuchElementException;
import org.apache.cayenne.ashwood.graph.ArcIterator;
import org.apache.commons.collections.Predicate;

public class FilterArcIterator<E, V>
implements ArcIterator<E, V> {
    private ArcIterator<E, V> iterator;
    private Predicate acceptOrigin;
    private Predicate acceptDestination;
    private Predicate acceptArc;
    private E nextOrigin;
    private E nextDst;
    private V nextArc;
    private boolean nextObjectSet = false;

    public FilterArcIterator(ArcIterator<E, V> iterator, Predicate acceptOrigin, Predicate acceptDestination, Predicate acceptArc) {
        this.iterator = iterator;
        this.acceptOrigin = acceptOrigin;
        this.acceptDestination = acceptDestination;
        this.acceptArc = acceptArc;
        this.nextOrigin = iterator.getOrigin();
        if (!acceptOrigin.evaluate(this.nextOrigin)) {
            this.nextOrigin = null;
        }
        this.nextDst = iterator.getDestination();
        if (!acceptDestination.evaluate(this.nextDst)) {
            this.nextDst = null;
        }
    }

    @Override
    public E getOrigin() {
        return this.nextOrigin;
    }

    @Override
    public E getDestination() {
        return this.nextDst;
    }

    @Override
    public boolean hasNext() {
        if (this.nextObjectSet) {
            return true;
        }
        return this.setNextObject();
    }

    @Override
    public V next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextArc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean setNextObject() {
        while (this.iterator.hasNext()) {
            Object arc = this.iterator.next();
            E origin = this.iterator.getOrigin();
            E dst = this.iterator.getDestination();
            if (!this.acceptOrigin.evaluate(origin) || !this.acceptArc.evaluate(arc) || !this.acceptDestination.evaluate(dst)) continue;
            this.nextArc = arc;
            this.nextOrigin = origin;
            this.nextDst = dst;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }
}

