/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.oracle.Oracle8LOBBatchAction;
import org.apache.cayenne.dba.oracle.Oracle8SQLTemplateAction;
import org.apache.cayenne.dba.oracle.Oracle8SelectAction;
import org.apache.cayenne.dba.oracle.OracleActionBuilder;
import org.apache.cayenne.dba.oracle.OracleAdapter;
import org.apache.cayenne.dba.oracle.OracleBatchAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

class Oracle8ActionBuilder
extends OracleActionBuilder {
    Oracle8ActionBuilder(DataNode dataNode) {
        super(dataNode);
    }

    @Override
    public SQLAction sqlAction(SQLTemplate query) {
        return new Oracle8SQLTemplateAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new Oracle8SelectAction(query, this.dataNode);
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        if (OracleAdapter.isSupportsOracleLOB() && OracleAdapter.updatesLOBColumns(query)) {
            return new Oracle8LOBBatchAction(query, this.dataNode.getAdapter(), this.dataNode.getJdbcEventLogger());
        }
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new OracleBatchAction(query, this.dataNode, runningAsBatch);
    }
}

