/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomainFlushAction;
import org.apache.cayenne.access.DataDomainLegacyQueryAction;
import org.apache.cayenne.access.DataDomainQueryAction;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.DomainStoppedException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.di.BeforeScopeEnd;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.event.EventManager;
import org.apache.cayenne.graph.CompoundDiff;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.EntitySorter;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryChain;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;
import org.apache.cayenne.util.ToStringBuilder;

public class DataDomain
implements QueryEngine,
DataChannel {
    public static final String SHARED_CACHE_ENABLED_PROPERTY = "cayenne.DataDomain.sharedCache";
    public static final boolean SHARED_CACHE_ENABLED_DEFAULT = true;
    public static final String VALIDATING_OBJECTS_ON_COMMIT_PROPERTY = "cayenne.DataDomain.validatingObjectsOnCommit";
    public static final boolean VALIDATING_OBJECTS_ON_COMMIT_DEFAULT = true;
    @Deprecated
    public static final String USING_EXTERNAL_TRANSACTIONS_PROPERTY = "cayenne.DataDomain.usingExternalTransactions";
    @Deprecated
    public static final boolean USING_EXTERNAL_TRANSACTIONS_DEFAULT = false;
    @Inject
    protected JdbcEventLogger jdbcEventLogger;
    @Inject
    protected TransactionManager transactionManager;
    protected int maxIdQualifierSize;
    protected List<DataChannelFilter> filters;
    protected Map<String, DataNode> nodes;
    protected Map<String, DataNode> nodesByDataMapName;
    protected DataNode defaultNode;
    protected Map<String, String> properties;
    protected EntityResolver entityResolver;
    protected DataRowStore sharedSnapshotCache;
    protected String name;
    protected QueryCache queryCache;
    protected boolean sharedCacheEnabled;
    protected boolean validatingObjectsOnCommit;
    protected EventManager eventManager;
    protected EntitySorter entitySorter;
    protected boolean stopped;

    public DataDomain(String name) {
        this.init(name);
        this.resetProperties();
    }

    @Deprecated
    public DataDomain(String name, Map properties) {
        this.init(name);
        this.initWithProperties(properties);
    }

    private void init(String name) {
        this.filters = new CopyOnWriteArrayList<DataChannelFilter>();
        this.nodesByDataMapName = new ConcurrentHashMap<String, DataNode>();
        this.nodes = new ConcurrentHashMap<String, DataNode>();
        this.properties = Collections.EMPTY_MAP;
        this.setName(name);
    }

    protected void checkStopped() throws DomainStoppedException {
        if (this.stopped) {
            throw new DomainStoppedException("Domain " + this.name + " was shutdown and can no longer be used to access the database", new Object[0]);
        }
    }

    public EntitySorter getEntitySorter() {
        return this.entitySorter;
    }

    public void setEntitySorter(EntitySorter entitySorter) {
        this.entitySorter = entitySorter;
    }

    protected void resetProperties() {
        this.properties = Collections.EMPTY_MAP;
        this.sharedCacheEnabled = true;
        this.validatingObjectsOnCommit = true;
    }

    @Deprecated
    public void initWithProperties(Map<String, String> properties) {
        properties = properties != null ? new HashMap(properties) : Collections.EMPTY_MAP;
        String sharedCacheEnabled = (String)properties.get(SHARED_CACHE_ENABLED_PROPERTY);
        String validatingObjectsOnCommit = (String)properties.get(VALIDATING_OBJECTS_ON_COMMIT_PROPERTY);
        this.sharedCacheEnabled = sharedCacheEnabled != null ? "true".equalsIgnoreCase(sharedCacheEnabled) : true;
        this.validatingObjectsOnCommit = validatingObjectsOnCommit != null ? "true".equalsIgnoreCase(validatingObjectsOnCommit) : true;
        this.properties = properties;
    }

    @Override
    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setEventManager(eventManager);
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
        if (this.sharedSnapshotCache != null) {
            this.sharedSnapshotCache.setName(name);
        }
    }

    public boolean isSharedCacheEnabled() {
        return this.sharedCacheEnabled;
    }

    public void setSharedCacheEnabled(boolean sharedCacheEnabled) {
        this.sharedCacheEnabled = sharedCacheEnabled;
    }

    public boolean isValidatingObjectsOnCommit() {
        return this.validatingObjectsOnCommit;
    }

    public void setValidatingObjectsOnCommit(boolean flag) {
        this.validatingObjectsOnCommit = flag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public DataRowStore getSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null && this.sharedCacheEnabled) {
            this.sharedSnapshotCache = this.nonNullSharedSnapshotCache();
        }
        return this.sharedSnapshotCache;
    }

    synchronized DataRowStore nonNullSharedSnapshotCache() {
        if (this.sharedSnapshotCache == null) {
            this.sharedSnapshotCache = new DataRowStore(this.name, this.properties, this.eventManager);
        }
        return this.sharedSnapshotCache;
    }

    public synchronized void setSharedSnapshotCache(DataRowStore snapshotCache) {
        if (this.sharedSnapshotCache != snapshotCache) {
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
            this.sharedSnapshotCache = snapshotCache;
            if (snapshotCache != null) {
                snapshotCache.setEventManager(this.getEventManager());
                snapshotCache.setName(this.getName());
            }
        }
    }

    public void addDataMap(DataMap dataMap) {
        this.getEntityResolver().addDataMap(dataMap);
        this.refreshEntitySorter();
    }

    public DataMap getDataMap(String mapName) {
        return this.getEntityResolver().getDataMap(mapName);
    }

    public void removeDataMap(String mapName) {
        DataMap map = this.getDataMap(mapName);
        if (map == null) {
            return;
        }
        for (DataNode node : this.nodes.values()) {
            node.removeDataMap(mapName);
        }
        this.nodesByDataMapName.remove(mapName);
        this.getEntityResolver().removeDataMap(map);
        this.refreshEntitySorter();
    }

    public void removeDataNode(String nodeName) {
        DataNode removed = this.nodes.remove(nodeName);
        if (removed != null) {
            removed.setEntityResolver(null);
            Iterator<DataNode> it = this.nodesByDataMapName.values().iterator();
            while (it.hasNext()) {
                if (it.next() != removed) continue;
                it.remove();
            }
        }
    }

    public Collection<DataMap> getDataMaps() {
        return this.getEntityResolver().getDataMaps();
    }

    public Collection<DataNode> getDataNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public void addNode(DataNode node) {
        this.nodes.put(node.getName(), node);
        node.setEntityResolver(this.getEntityResolver());
        for (DataMap map : node.getDataMaps()) {
            this.addDataMap(map);
            this.nodesByDataMapName.put(map.getName(), node);
        }
    }

    public DataNode getDataNode(String nodeName) {
        return this.nodes.get(nodeName);
    }

    public DataNode lookupDataNode(DataMap map) {
        DataNode node = this.nodesByDataMapName.get(map.getName());
        if (node == null) {
            for (DataNode n : this.getDataNodes()) {
                for (DataMap m : n.getDataMaps()) {
                    if (m != map) continue;
                    this.nodesByDataMapName.put(map.getName(), n);
                    node = n;
                    break;
                }
                if (node == null) continue;
                break;
            }
            if (node == null) {
                if (this.defaultNode != null) {
                    this.nodesByDataMapName.put(map.getName(), this.defaultNode);
                    node = this.defaultNode;
                } else {
                    throw new CayenneRuntimeException("No DataNode configured for DataMap '" + map.getName() + "' and no default DataNode set", new Object[0]);
                }
            }
        }
        return node;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    private synchronized void createEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new EntityResolver();
        }
    }

    @BeforeScopeEnd
    public void shutdown() {
        if (!this.stopped) {
            this.stopped = true;
            if (this.sharedSnapshotCache != null) {
                this.sharedSnapshotCache.shutdown();
            }
        }
    }

    @Override
    public void performQueries(final Collection<? extends Query> queries, final OperationObserver callback) {
        this.transactionManager.performInTransaction(new TransactionalOperation<Object>(){

            @Override
            public Object perform() {
                new DataDomainLegacyQueryAction(DataDomain.this, new QueryChain(queries), callback).execute();
                return null;
            }
        });
    }

    @Override
    public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
        this.checkStopped();
        return new DataDomainQueryFilterChain().onQuery(originatingContext, query);
    }

    QueryResponse onQueryNoFilters(ObjectContext originatingContext, Query query) {
        return new DataDomainQueryAction(originatingContext, this, query).execute();
    }

    @Override
    public EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.createEntityResolver();
        }
        return this.entityResolver;
    }

    @Override
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        this.checkStopped();
        return new DataDomainSyncFilterChain().onSync(originatingContext, changes, syncType);
    }

    GraphDiff onSyncNoFilters(ObjectContext originatingContext, GraphDiff changes, int syncType) {
        GraphDiff result;
        switch (syncType) {
            case 3: {
                result = this.onSyncRollback(originatingContext);
                break;
            }
            case 1: 
            case 2: {
                result = this.onSyncFlush(originatingContext, changes);
                break;
            }
            default: {
                throw new CayenneRuntimeException("Invalid synchronization type: " + syncType, new Object[0]);
            }
        }
        return result;
    }

    GraphDiff onSyncRollback(ObjectContext originatingContext) {
        Transaction transaction = BaseTransaction.getThreadTransaction();
        if (transaction != null) {
            transaction.setRollbackOnly();
        }
        return new CompoundDiff();
    }

    GraphDiff onSyncFlush(ObjectContext originatingContext, GraphDiff childChanges) {
        if (!(originatingContext instanceof DataContext)) {
            throw new CayenneRuntimeException("No support for committing ObjectContexts that are not DataContexts yet. Unsupported context: " + originatingContext, new Object[0]);
        }
        DataDomainFlushAction action = new DataDomainFlushAction(this);
        action.setJdbcEventLogger(this.jdbcEventLogger);
        return action.flush((DataContext)originatingContext, childChanges);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).toString();
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(QueryCache queryCache) {
        this.queryCache = queryCache;
    }

    JdbcEventLogger getJdbcEventLogger() {
        return this.jdbcEventLogger;
    }

    void refreshEntitySorter() {
        if (this.entitySorter != null) {
            this.entitySorter.setEntityResolver(this.getEntityResolver());
        }
    }

    public List<DataChannelFilter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public void addFilter(DataChannelFilter filter) {
        filter.init(this);
        this.getEntityResolver().getCallbackRegistry().addListener(filter);
        this.filters.add(filter);
    }

    public void removeFilter(DataChannelFilter filter) {
        this.filters.remove(filter);
    }

    public void addListener(Object listener) {
        this.getEntityResolver().getCallbackRegistry().addListener(listener);
    }

    public DataNode getDefaultNode() {
        return this.defaultNode;
    }

    public void setDefaultNode(DataNode defaultNode) {
        this.defaultNode = defaultNode;
    }

    public int getMaxIdQualifierSize() {
        return this.maxIdQualifierSize;
    }

    public void setMaxIdQualifierSize(int maxIdQualifierSize) {
        this.maxIdQualifierSize = maxIdQualifierSize;
    }

    TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    final class DataDomainSyncFilterChain
    extends DataDomainFilterChain {
        DataDomainSyncFilterChain() {
        }

        @Override
        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            DataChannelFilter filter = this.nextFilter();
            return filter != null ? filter.onSync(originatingContext, changes, syncType, this) : DataDomain.this.onSyncNoFilters(originatingContext, changes, syncType);
        }

        @Override
        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            throw new UnsupportedOperationException("It is illegal to call 'onQuery' inside 'onSync' chain");
        }
    }

    final class DataDomainQueryFilterChain
    extends DataDomainFilterChain {
        DataDomainQueryFilterChain() {
        }

        @Override
        public QueryResponse onQuery(ObjectContext originatingContext, Query query) {
            DataChannelFilter filter = this.nextFilter();
            return filter != null ? filter.onQuery(originatingContext, query, this) : DataDomain.this.onQueryNoFilters(originatingContext, query);
        }

        @Override
        public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType) {
            throw new UnsupportedOperationException("It is illegal to call 'onSync' inside 'onQuery' chain");
        }
    }

    abstract class DataDomainFilterChain
    implements DataChannelFilterChain {
        private int i;

        DataDomainFilterChain() {
            this.i = DataDomain.this.filters != null ? DataDomain.this.filters.size() : 0;
        }

        DataChannelFilter nextFilter() {
            --this.i;
            return this.i >= 0 ? DataDomain.this.filters.get(this.i) : null;
        }
    }
}

