/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.loader.DbAttributesBaseLoader;
import org.apache.cayenne.access.loader.filters.PatternFilter;
import org.apache.cayenne.access.loader.filters.TableFilter;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;

public class DbAttributesPerSchemaLoader
extends DbAttributesBaseLoader {
    private final TableFilter filter;
    private Map<String, List<DbAttribute>> attributes;

    public DbAttributesPerSchemaLoader(String catalog, String schema, DatabaseMetaData metaData, DbAdapter adapter, TableFilter filter) {
        super(catalog, schema, metaData, adapter);
        this.filter = filter;
    }

    private Map<String, List<DbAttribute>> loadDbAttributes() throws SQLException {
        HashMap<String, List<DbAttribute>> attributes = new HashMap<String, List<DbAttribute>>();
        try (ResultSet rs = this.getMetaData().getColumns(this.getCatalog(), this.getSchema(), "%", "%");){
            HashSet<String> columns = new HashSet<String>();
            while (rs.next()) {
                if (columns.isEmpty()) {
                    ResultSetMetaData rsMetaData = rs.getMetaData();
                    for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                        columns.add(rsMetaData.getColumnLabel(i));
                    }
                }
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                PatternFilter columnFilter = this.filter.isIncludeTable(tableName);
                if (columnFilter == null || !columnFilter.isInclude(columnName)) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)("Skip column '" + tableName + "." + columnName + "' (Path: " + this.getCatalog() + "/" + this.getSchema() + "; Filter: " + columnFilter + ")"));
                    continue;
                }
                LinkedList<DbAttribute> attrs = (LinkedList<DbAttribute>)attributes.get(tableName);
                if (attrs == null) {
                    attrs = new LinkedList<DbAttribute>();
                    attributes.put(tableName, attrs);
                }
                attrs.add(this.loadDbAttribute(columns, rs));
            }
        }
        return attributes;
    }

    @Override
    protected List<DbAttribute> loadDbAttributes(String tableName) {
        Map<String, List<DbAttribute>> attributes = this.getAttributes();
        if (attributes != null) {
            return attributes.get(tableName);
        }
        return new LinkedList<DbAttribute>();
    }

    public Map<String, List<DbAttribute>> getAttributes() {
        if (this.attributes == null) {
            try {
                this.attributes = this.loadDbAttributes();
            }
            catch (SQLException e) {
                LOGGER.error((Object)e);
                this.attributes = new HashMap<String, List<DbAttribute>>();
            }
        }
        return this.attributes;
    }
}

