/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.loader.filters;

import java.util.Arrays;
import org.apache.cayenne.access.loader.filters.SchemaFilter;

public class CatalogFilter {
    public final String name;
    public final SchemaFilter[] schemas;

    public CatalogFilter(String name, SchemaFilter ... schemas) {
        if (schemas == null || schemas.length == 0) {
            throw new IllegalArgumentException("schemas(" + Arrays.toString(schemas) + ") can't be null or empty");
        }
        this.name = name;
        this.schemas = schemas;
    }

    public SchemaFilter getSchema(String schema) {
        for (SchemaFilter schemaFilter : this.schemas) {
            if (schemaFilter.name != null && !schemaFilter.name.equals(schema)) continue;
            return schemaFilter;
        }
        return null;
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder res, String prefix) {
        res.append(prefix).append("Catalog: ").append(this.name).append("\n");
        for (SchemaFilter schema : this.schemas) {
            schema.toString(res, prefix + "  ");
        }
        return res;
    }
}

