/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.JoinType;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;

public abstract class QueryAssembler {
    protected Query query;
    protected QueryMetadata queryMetadata;
    protected boolean translated;
    protected String sql;
    protected DbAdapter adapter;
    protected EntityResolver entityResolver;
    protected List<ParameterBinding> bindings;

    public QueryAssembler(Query query, DbAdapter adapter, EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.adapter = adapter;
        this.query = query;
        this.queryMetadata = query.getMetaData(entityResolver);
        this.bindings = new ArrayList<ParameterBinding>();
    }

    protected Map<String, String> getPathAliases() {
        return this.queryMetadata.getPathSplitAliases();
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }

    public Query getQuery() {
        return this.query;
    }

    public QueryMetadata getQueryMetadata() {
        return this.queryMetadata;
    }

    public abstract void resetJoinStack();

    public abstract String getCurrentAlias();

    public abstract void dbRelationshipAdded(DbRelationship var1, JoinType var2, String var3);

    public String getSql() {
        this.ensureTranslated();
        return this.sql;
    }

    protected void ensureTranslated() {
        if (!this.translated) {
            this.doTranslate();
            this.translated = true;
        }
    }

    protected abstract void doTranslate();

    public boolean supportsTableAliases() {
        return false;
    }

    public void addToParamList(DbAttribute dbAttr, Object anObject) {
        ParameterBinding binding = new ParameterBinding(dbAttr);
        binding.setValue(anObject);
        binding.setStatementPosition(this.bindings.size() + 1);
        this.bindings.add(binding);
    }

    public ParameterBinding[] getBindings() {
        return this.bindings.toArray(new ParameterBinding[this.bindings.size()]);
    }
}

