/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeDecorator;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SerializableTypeFactory
implements ExtendedTypeFactory {
    private static final Log logger = LogFactory.getLog(SerializableTypeFactory.class);
    private ExtendedTypeMap map;

    SerializableTypeFactory(ExtendedTypeMap map) {
        this.map = map;
    }

    @Override
    public ExtendedType getType(Class<?> objectClass) {
        logger.warn((Object)("Haven't found suitable ExtendedType for class '" + objectClass.getCanonicalName() + "'. Most likely you need to define a custom ExtendedType."));
        if (Serializable.class.isAssignableFrom(objectClass)) {
            logger.warn((Object)"SerializableType will be used for type conversion.");
            ExtendedType bytesType = this.map.getExplictlyRegisteredType("byte[]");
            if (bytesType instanceof SerializableType) {
                throw new IllegalStateException("Can't create Serializable ExtendedType for " + objectClass.getCanonicalName() + ": no ExtendedType exists for byte[]");
            }
            return new SerializableType(objectClass, bytesType);
        }
        return null;
    }

    final class SerializableType
    extends ExtendedTypeDecorator {
        private Class<?> javaClass;

        SerializableType(Class<?> javaClass, ExtendedType bytesType) {
            super(bytesType);
            this.javaClass = javaClass;
        }

        @Override
        public String getClassName() {
            return this.javaClass.getCanonicalName();
        }

        @Override
        Object fromJavaObject(Object object) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

                @Override
                public synchronized byte[] toByteArray() {
                    return this.buf;
                }
            };
            try (ObjectOutputStream out = new ObjectOutputStream(bytes);){
                out.writeObject(object);
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error serializing object", (Throwable)e, new Object[0]);
            }
            return bytes.toByteArray();
        }

        @Override
        Object toJavaObject(Object object) {
            byte[] bytes = (byte[])object;
            try {
                return bytes != null && bytes.length > 0 ? new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject() : null;
            }
            catch (Exception e) {
                throw new CayenneRuntimeException("Error deserializing object", (Throwable)e, new Object[0]);
            }
        }
    }
}

