/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslatorFactory;
import org.apache.cayenne.access.types.ByteArrayType;
import org.apache.cayenne.access.types.ByteType;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.access.types.ShortType;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.DefaultQuotingStrategy;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.sybase.SybaseEJBQLTranslatorFactory;
import org.apache.cayenne.dba.sybase.SybaseMergerFactory;
import org.apache.cayenne.dba.sybase.SybasePkGenerator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.resource.ResourceLocator;

public class SybaseAdapter
extends JdbcAdapter {
    public SybaseAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
    }

    @Override
    protected QuotingStrategy createQuotingStrategy() {
        return new DefaultQuotingStrategy("[", "]");
    }

    @Override
    protected EJBQLTranslatorFactory createEJBQLTranslatorFactory() {
        return new SybaseEJBQLTranslatorFactory();
    }

    @Override
    public String getBatchTerminator() {
        return "go";
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new ByteArrayType(true, false));
        map.registerType(new ShortType(true));
        map.registerType(new ByteType(true));
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new SybasePkGenerator(this);
    }

    @Override
    public void bindParameter(PreparedStatement statement, Object object, int pos, int sqlType, int precision) throws SQLException, Exception {
        if (object == null) {
            if (sqlType == 2005) {
                sqlType = 12;
            } else if (sqlType == 2004) {
                sqlType = -3;
            }
        }
        if (object == null && sqlType == 0) {
            statement.setNull(pos, 12);
        } else {
            super.bindParameter(statement, object, pos, sqlType, precision);
        }
    }

    @Override
    public MergerFactory mergerFactory() {
        return new SybaseMergerFactory();
    }
}

