/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.NameConverter;
import org.apache.cayenne.map.naming.ObjectNameGenerator;

public class LegacyNameGenerator
implements ObjectNameGenerator {
    @Override
    public String createDbRelationshipName(ExportedKey key, boolean toMany) {
        String uglyName = toMany ? key.getFKTableName() + "_ARRAY" : "to_" + key.getPKTableName();
        return NameConverter.underscoredToJava(uglyName, false);
    }

    @Override
    public String createObjEntityName(DbEntity dbEntity) {
        return NameConverter.underscoredToJava(dbEntity.getName(), true);
    }

    @Override
    public String createObjAttributeName(DbAttribute attr) {
        return NameConverter.underscoredToJava(attr.getName(), false);
    }

    @Override
    public String createObjRelationshipName(DbRelationship dbRel) {
        return NameConverter.underscoredToJava(dbRel.getName(), false);
    }
}

