/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.access.jdbc.SQLParameterBinding;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.ValueForNullProvider;

public class DefaultValueForNullProvider
implements ValueForNullProvider {
    private Map<String, SQLParameterBinding> values = new HashMap<String, SQLParameterBinding>();

    public void set(DbEntity entity, DbAttribute column, Object value, int type) {
        this.values.put(this.createKey(entity, column), new SQLParameterBinding(value, type, column.getAttributePrecision()));
    }

    protected SQLParameterBinding get(DbEntity entity, DbAttribute column) {
        return this.values.get(this.createKey(entity, column));
    }

    @Override
    public List<String> createSql(DbEntity entity, DbAttribute column) {
        SQLParameterBinding value = this.get(entity, column);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList("UPDATE " + entity.getFullyQualifiedName() + " SET " + column.getName() + "='" + value.getValue() + "' WHERE " + column.getName() + " IS NULL");
    }

    @Override
    public boolean hasValueFor(DbEntity entity, DbAttribute column) {
        return this.values.containsKey(this.createKey(entity, column));
    }

    private String createKey(DbEntity entity, DbAttribute attribute) {
        return (entity.getFullyQualifiedName() + "." + attribute.getName()).toUpperCase();
    }
}

