/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.DbRelationshipDetected;
import org.apache.cayenne.merge.AbstractToDbToken;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class DropRelationshipToDb
extends AbstractToDbToken.Entity {
    private DbRelationship rel;

    public DropRelationshipToDb(DbEntity entity, DbRelationship rel) {
        super("Drop foreign key", entity);
        this.rel = rel;
    }

    public String getFkName() {
        if (this.rel instanceof DbRelationshipDetected) {
            return ((DbRelationshipDetected)this.rel).getFkName();
        }
        return null;
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        String fkName = this.getFkName();
        if (fkName == null) {
            return Collections.emptyList();
        }
        QuotingStrategy context = adapter.getQuotingStrategy();
        return Collections.singletonList("ALTER TABLE " + context.quotedFullyQualifiedName(this.getEntity()) + " DROP CONSTRAINT " + fkName);
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createAddRelationshipToModel(this.getEntity(), this.rel);
    }

    @Override
    public String getTokenValue() {
        return this.rel.getSourceEntity().getName() + "->" + this.rel.getTargetEntityName();
    }

    public DbRelationship getRelationship() {
        return this.rel;
    }
}

