/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.event.AttributeEvent;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;

public class SetPrimaryKeyToModel
extends AbstractToModelToken.Entity {
    private Collection<DbAttribute> primaryKeyOriginal;
    private Collection<DbAttribute> primaryKeyNew;
    private String detectedPrimaryKeyName;
    private Set<String> primaryKeyNewAttributeNames = new HashSet<String>();

    public SetPrimaryKeyToModel(DbEntity entity, Collection<DbAttribute> primaryKeyOriginal, Collection<DbAttribute> primaryKeyNew, String detectedPrimaryKeyName) {
        super("Set Primary Key", entity);
        this.primaryKeyOriginal = primaryKeyOriginal;
        this.primaryKeyNew = primaryKeyNew;
        this.detectedPrimaryKeyName = detectedPrimaryKeyName;
        for (DbAttribute attr : primaryKeyNew) {
            this.primaryKeyNewAttributeNames.add(attr.getName().toUpperCase());
        }
    }

    @Override
    public MergerToken createReverse(MergerFactory factory) {
        return factory.createSetPrimaryKeyToDb(this.getEntity(), this.primaryKeyNew, this.primaryKeyOriginal, this.detectedPrimaryKeyName);
    }

    @Override
    public void execute(MergerContext mergerContext) {
        DbEntity e = this.getEntity();
        for (DbAttribute attr : e.getAttributes()) {
            boolean willBePrimaryKey;
            boolean wasPrimaryKey = attr.isPrimaryKey();
            if (wasPrimaryKey == (willBePrimaryKey = this.primaryKeyNewAttributeNames.contains(attr.getName().toUpperCase()))) continue;
            attr.setPrimaryKey(willBePrimaryKey);
            e.dbAttributeChanged(new AttributeEvent((Object)this, attr, e));
            mergerContext.getModelMergeDelegate().dbAttributeModified(attr);
        }
    }
}

