/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.cayenne.configuration.ConfigurationNodeVisitor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.BatchQueryRow;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;

public abstract class BatchQuery
implements Query {
    protected DbEntity dbEntity;
    protected String name;
    protected DataMap dataMap;
    protected List<BatchQueryRow> rows;
    protected List<DbAttribute> dbAttributes;

    public BatchQuery(DbEntity dbEntity, List<DbAttribute> dbAttributes, int batchCapacity) {
        this.dbEntity = dbEntity;
        this.rows = new ArrayList<BatchQueryRow>(batchCapacity);
        this.dbAttributes = dbAttributes;
    }

    public List<BatchQueryRow> getRows() {
        return this.rows;
    }

    @Override
    public <T> T acceptVisitor(ConfigurationNodeVisitor<T> visitor) {
        return visitor.visitQuery(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        return new DefaultQueryMetadata(){

            @Override
            public DbEntity getDbEntity() {
                return BatchQuery.this.dbEntity;
            }
        };
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        router.route(router.engineForDataMap(this.dbEntity.getDataMap()), this, substitutedQuery);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.batchAction(this);
    }

    public boolean isUsingOptimisticLocking() {
        return false;
    }

    public DbEntity getDbEntity() {
        return this.dbEntity;
    }

    public List<DbAttribute> getDbAttributes() {
        return this.dbAttributes;
    }

    @Deprecated
    public int size() {
        return this.rows.size();
    }
}

