/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tx;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.tx.TransactionFactory;
import org.apache.cayenne.tx.TransactionManager;
import org.apache.cayenne.tx.TransactionalOperation;

public class DefaultTransactionManager
implements TransactionManager {
    private TransactionFactory txFactory;
    private JdbcEventLogger jdbcEventLogger;

    public DefaultTransactionManager(@Inject TransactionFactory txFactory, @Inject JdbcEventLogger jdbcEventLogger) {
        this.txFactory = txFactory;
        this.jdbcEventLogger = jdbcEventLogger;
    }

    @Override
    public <T> T performInTransaction(TransactionalOperation<T> op) {
        Transaction currentTx = BaseTransaction.getThreadTransaction();
        if (currentTx != null) {
            return op.perform();
        }
        Transaction tx = this.txFactory.createTransaction();
        BaseTransaction.bindThreadTransaction(tx);
        try {
            T result = op.perform();
            tx.commit();
            T t = result;
            return t;
        }
        catch (CayenneRuntimeException ex) {
            tx.setRollbackOnly();
            throw ex;
        }
        catch (Exception ex) {
            tx.setRollbackOnly();
            throw new CayenneRuntimeException(ex);
        }
        finally {
            BaseTransaction.bindThreadTransaction(null);
            if (tx.isRollbackOnly()) {
                try {
                    tx.rollback();
                }
                catch (Exception e) {
                    this.jdbcEventLogger.logQueryError(e);
                }
            }
        }
    }
}

